/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ActionInterceptor
extends HandlerInterceptorAdapter {
    @Value(value="${ms.manager.path}")
    private String managerPath;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String modelId = request.getParameter("modelId");
        if (NumberUtils.isNumber((String)modelId)) {
            request.setAttribute("modelId", (Object)modelId);
            request.getSession().setAttribute(SessionConstEnum.MODEL_ID_SESSION.toString(), (Object)modelId);
            request.getSession().setAttribute(SessionConstEnum.MODEL_TITLE_SESSION.toString(), (Object)request.getParameter("modelTitle"));
        }
        String base = request.getScheme() + "://" + request.getServerName() + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        String contextPath = request.getServletContext().getContextPath();
        request.setAttribute("base", (Object)contextPath);
        request.setAttribute("managerPath", (Object)(contextPath + this.managerPath));
        request.setAttribute("basePath", (Object)(base + contextPath));
        request.setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams());
        return true;
    }
}

