package net.mingsoft.basic.resolver;

import cn.hutool.core.util.ObjectUtil;
import net.mingsoft.base.resolver.MultipartResolver;
import net.mingsoft.basic.config.MultipartProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 自动注入解决百度编辑器的上传组件与CommonsMultipartResolver的冲突问题
 * 不可同时配置 MultipartConfigElement 和 CommonsMultipartResolver
 * @author by Administrator
 * @Description TODO
 * @date 2019/9/29 17:11
 */
@Component
@EnableConfigurationProperties(MultipartProperties.class)
public class CustomMultipartResolver extends MultipartResolver {
    public CustomMultipartResolver(MultipartProperties multipartProperties) throws IOException {
      if(ObjectUtil.isNotNull(multipartProperties.getUploadTempDir())){
          setUploadTempDir(multipartProperties.getUploadTempDir());
      }
      setDefaultEncoding(multipartProperties.getDefaultEncoding());
      setMaxUploadSize(multipartProperties.getMaxFileSize());
      setMaxUploadSizePerFile(multipartProperties.getMaxRequestSize());
      setMaxInMemorySize(multipartProperties.getMaxInMemorySize());
      setResolveLazily(multipartProperties.isResolveLazily());
      setExcludeUrls("jsp/editor.do");
    }


}
