/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.IOException;
import net.mingsoft.base.action.BaseAction;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

public abstract class BaseFileAction
extends BaseAction {
    @Value(value="${ms.upload.path}")
    private String uploadFloderPath;
    @Value(value="${ms.upload.mapping}")
    private String uploadMapping;
    @Value(value="${ms.upload.denied}")
    private String uploadFileDenied;

    public String upload(Config config) throws IOException {
        String realPath;
        String[] errorType = this.uploadFileDenied.split(",");
        String fileName = config.getFile().getOriginalFilename();
        String fileType = fileName.substring(fileName.indexOf("."));
        boolean isReal = new File(this.uploadFloderPath).isAbsolute();
        String string = isReal ? this.uploadMapping : (this.uploadMapping = config.uploadFloderPath ? "" : this.uploadFloderPath);
        String string2 = isReal ? this.uploadFloderPath : (realPath = config.uploadFloderPath ? BasicUtil.getRealPath("") : BasicUtil.getRealPath(this.uploadFloderPath));
        if (StringUtils.isNotBlank((CharSequence)config.getRootPath())) {
            realPath = config.getRootPath();
        }
        if (!config.isRename()) {
            fileName = config.getFile().getOriginalFilename();
            if (fileName.endsWith(".") && System.getProperty("os.name").startsWith("Windows")) {
                this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileName);
                return "";
            }
            fileType = fileName.substring(fileName.lastIndexOf("."));
        } else {
            fileName = System.currentTimeMillis() + fileType;
        }
        for (String type : errorType) {
            if (!fileType.equals(type)) continue;
            this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileType);
            return "";
        }
        String uploadFolder = realPath + File.separator;
        if (StringUtils.isNotBlank((CharSequence)config.getUploadPath())) {
            uploadFolder = uploadFolder + config.getUploadPath() + File.separator;
        }
        File saveFolder = new File(uploadFolder);
        File saveFile = new File(uploadFolder, fileName);
        if (!saveFolder.exists()) {
            FileUtil.mkdir((File)saveFolder);
        }
        config.getFile().transferTo(saveFile);
        String path = this.uploadMapping.replace("**", "") + uploadFolder.replace(realPath, "") + "/" + fileName;
        return new File("/" + path).getPath().replace("\\", "/").replace("//", "/");
    }

    public class Config
    extends Bean {
        private String rootPath;
        private boolean uploadFloderPath;

        public Config() {
        }

        public Config(String fileName, String rootPath) {
            this.rootPath = rootPath;
        }

        public Config(String uploadPath, MultipartFile file, String rootPath, boolean uploadFloderPath) {
            this.rootPath = rootPath;
            this.uploadFloderPath = uploadFloderPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
        }

        public Config(String uploadPath, MultipartFile file, String rootPath) {
            this.rootPath = rootPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
        }

        public Config(String uploadPath, MultipartFile file, String rootPath, boolean uploadFloderPath, boolean rename) {
            this.rootPath = rootPath;
            this.uploadFloderPath = uploadFloderPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
            this.setRename(rename);
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        public boolean isUploadFloderPath() {
            return this.uploadFloderPath;
        }

        public void setUploadFloderPath(boolean uploadFloderPath) {
            this.uploadFloderPath = uploadFloderPath;
        }
    }

    public class Bean {
        private String uploadPath;
        private MultipartFile file;
        private boolean rename = true;

        public boolean isRename() {
            return this.rename;
        }

        public void setRename(boolean rename) {
            this.rename = rename;
        }

        public String getUploadPath() {
            return this.uploadPath;
        }

        public void setUploadPath(String uploadPath) {
            this.uploadPath = uploadPath;
        }

        public MultipartFile getFile() {
            return this.file;
        }

        public void setFile(MultipartFile file) {
            this.file = file;
        }
    }
}

