package net.mingsoft.basic.annotation;

import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.OperatorTypeEnum;

import java.lang.annotation.*;

/**
 * @author by 铭飞开源团队
 * @Description TODO
 * @date 2019/11/20 9:58
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface LogAnn {
    /**
     * 日志标题
     * @return
     */
    String title() default "";

    /**
     * 业务类型
     * @return
     */
    BusinessTypeEnum businessType() default BusinessTypeEnum.OTHER;

    /**
     * 操作人员类型
     * @return
     */
    OperatorTypeEnum operatorType() default OperatorTypeEnum.MANAGE;

    /**
     * 是否保存请求的参数
     * @return
     */
    boolean isSaveRequestData() default true;
}
