package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import net.mingsoft.base.constant.Const;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;

/**
 * @author by Administrator
 * @Description TODO
 * @date 2019/9/29 13:46
 */
public abstract class BaseFileAction extends net.mingsoft.base.action.BaseAction{
    /**
     * 上传路径
     */
    @Value("${ms.upload.path}")
    private String uploadFloderPath;
    /**
     * 上传路径映射
     */
    @Value("${ms.upload.mapping}")
    private String uploadMapping;

    @Value("${ms.upload.denied}")
    private String uploadFileDenied;


    /**
     * 统一上传文件方法
     * @param config
     * @return
     * @throws IOException
     */
    public String upload(Config config) throws IOException {
        // 过滤掉的文件类型
        String[] errorType = uploadFileDenied.split(",");
        //文件上传类型限制
        String fileName=config.getFile().getOriginalFilename();
        String fileType=fileName.substring(fileName.indexOf("."));
        boolean isReal = new File(uploadFloderPath).isAbsolute();
        //根据是否是绝对路径判断是否要加mapping
        uploadMapping = isReal?uploadMapping:config.uploadFloderPath?"":uploadFloderPath;
        //绝对路径
        String realPath = isReal? uploadFloderPath:config.uploadFloderPath?BasicUtil.getRealPath(""):BasicUtil.getRealPath(uploadFloderPath) ;
        //修改上传物理路径
        if(StringUtils.isNotBlank(config.getRootPath())){
            realPath=config.getRootPath();
        }
        //修改文件名
        if(!config.isRename()){
            fileName=config.getFile().getOriginalFilename();
            //Windows 系统下文件名最后会去掉. 这种文件默认拒绝  xxx.jsp. => xxx.jsp
            if(fileName.endsWith(".")&&System.getProperty("os.name").startsWith("Windows")){
                LOG.info("文件类型被拒绝:{}",fileName);
                return "";
            }
            fileType=fileName.substring(fileName.lastIndexOf("."));
        }else {
            //取随机名
            fileName=System.currentTimeMillis()+fileType;
        }
        for (String type : errorType) {
            if((fileType).equals(type)){
                LOG.info("文件类型被拒绝:{}",fileType);
                return "";
            }
        }
        // 上传的文件路径,判断是否填的绝对路径
        String uploadFolder = realPath +  File.separator;
        //修改upload下的上传路径
        if(StringUtils.isNotBlank(config.getUploadPath())){
            uploadFolder+=config.getUploadPath()+ File.separator;
        }
        //保存文件
        File saveFolder = new File(uploadFolder);
        File saveFile=new File(uploadFolder,fileName);
        if(!saveFolder.exists()){
            FileUtil.mkdir(saveFolder);
        }
        config.getFile().transferTo(saveFile);
        //绝对映射路径处理
        String path=uploadMapping.replace("**","")
                        //转为相对路径
                        + uploadFolder.replace(realPath,"")
                        //添加文件名
                        +  Const.SEPARATOR + fileName;
        //替换多余
        return new File(Const.SEPARATOR + path).getPath().replace("\\","/").replace("//","/");
    }

    public class Bean{
        /**
         * 上传文件夹
         */
        private String uploadPath;
        private MultipartFile file;


        private boolean rename =true;


        public boolean isRename() {
            return rename;
        }

        public void setRename(boolean rename) {
            this.rename = rename;
        }

        public String getUploadPath() {
            return uploadPath;
        }

        public void setUploadPath(String uploadPath) {
            this.uploadPath = uploadPath;
        }

        public MultipartFile getFile() {
            return file;
        }

        public void setFile(MultipartFile file) {
            this.file = file;
        }
    }

    /**
     *上传配置
     */
    public class Config extends Bean{

        /**
         * 上传根目录，由业务决定
         */
        private String rootPath;
        /**
         * 是否重定向到项目目录,针对老版本兼容的临时处理
         */
        private boolean uploadFloderPath;
        public Config() {
        }
        public Config(String fileName, String rootPath) {
            this.rootPath = rootPath;
        }

        public Config(String uploadPath, MultipartFile file, String rootPath,boolean uploadFloderPath) {
            this.rootPath = rootPath;
            this.uploadFloderPath = uploadFloderPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
        }
        public Config(String uploadPath, MultipartFile file, String rootPath) {
            this.rootPath = rootPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
        }

        public Config(String uploadPath, MultipartFile file, String rootPath, boolean uploadFloderPath, boolean rename) {
            this.rootPath = rootPath;
            this.uploadFloderPath = uploadFloderPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
            this.setRename(rename);
        }

        public String getRootPath() {
            return rootPath;
        }

        public void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        public boolean isUploadFloderPath() {
            return uploadFloderPath;
        }

        public void setUploadFloderPath(boolean uploadFloderPath) {
            this.uploadFloderPath = uploadFloderPath;
        }
    }

}
