package net.mingsoft.basic.aop;

import cn.hutool.core.util.ObjectUtil;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.Date;

/**
 * @author by Administrator
 * @Description TODO
 * @date 2019/11/12 10:14
 */
@Component
@Aspect
public class SaveOrUpdateAop extends BaseAop{

    @Pointcut("execution(* net.mingsoft..*Action.save(..))")
    public void save() {

    }@Pointcut("execution(* net.mingsoft..*Action.update(..))")
    public void update() {


    }
    @Before("save()")
    public void save(JoinPoint jp) {
        setField(jp, "createDate",new Date());
        ManagerSessionEntity session = (ManagerSessionEntity)BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION);
        if(session!=null){
            setField(jp, "createBy",session.getManagerId());
            setField(jp, "createBy",session.getManagerId());
        }

    }


    @Before("update()")
    public void update(JoinPoint jp) {
        setField(jp, "updateDate",new Date());
        ManagerSessionEntity session = (ManagerSessionEntity)BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION);
        if(session!=null){
            setField(jp, "updateBy",session.getManagerId());
        }
    }


    private void setField(JoinPoint jp, String name,Object obj) {
        try {
            Object[] objs = jp.getArgs();
            if (objs.length == 0 || ObjectUtil.isNull(objs[0])) {
                return;
            }
            //获取对象所有字段
            Field[] allFields = BasicUtil.getAllFields(objs[0]);
            for (Field field : allFields) {
                //判断是否存在
                if (name.equals(field.getName())) {
                    field.setAccessible(true);
                    //设置时间
                    field.set(objs[0], obj);
                }
            }
        } catch (Exception e) {
            LOG.error("Aop错误：", e);
        }
    }

}
