package net.mingsoft.basic.action.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.mingsoft.basic.action.BaseFileAction;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.base.constant.Const;
import net.mingsoft.basic.action.BaseAction;

import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.FileUtil;

/**
 * 上传文件
 */
@Api("上传文件接口")
@Controller
@RequestMapping("/file")
public class FileAction extends BaseFileAction {


	@Value("${ms.upload.denied}")
	private String uploadFileDenied;


	/**
	 * 处理post请求上传文件
	 * 
	 * @param req
	 *            HttpServletRequest对象
	 * @param res
	 *            HttpServletResponse 对象
	 * @throws ServletException
	 *             异常处理
	 * @throws IOException
	 *             异常处理
	 */
	@ApiOperation(value = "处理post请求上传文件")
	@PostMapping("/upload")
	@ResponseBody
	public void upload(Bean bean,boolean appId,HttpServletRequest req, HttpServletResponse res) throws IOException {
		if(appId){
			//拼接AppId
			bean.setUploadPath(BasicUtil.getAppId()+File.separator+bean.getUploadPath());
		}
		Config config = new Config(bean.getUploadPath(),bean.getFile(),null);
		this.outString(res,this.upload(config));
	}
}
