/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Date;
import java.util.Map;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.aop.SystemLogAop;
import net.mingsoft.basic.biz.ISystemLogBiz;
import net.mingsoft.basic.entity.SystemLogEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;

@Aspect
public abstract class BaseLogAop
extends BaseAop {
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    @Autowired
    private ISystemLogBiz systemLogBiz;
    private static final Logger LOG = LoggerFactory.getLogger(SystemLogAop.class);

    public abstract String getUserName();

    public abstract boolean isCut(LogAnn var1);

    @Pointcut(value="@annotation(net.mingsoft.basic.annotation.LogAnn)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="logPointCut()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) {
        this.handleLog(joinPoint, null, result);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Exception e, Object result) {
        try {
            LogAnn controllerLog = this.getAnnotation(joinPoint, LogAnn.class);
            if (controllerLog == null) {
                return;
            }
            if (!this.isCut(controllerLog)) {
                return;
            }
            SystemLogEntity systemLogEntity = new SystemLogEntity();
            systemLogEntity.setUser(this.getUserName());
            systemLogEntity.setStatus(SUCCESS);
            String ip = BasicUtil.getIp();
            systemLogEntity.setIp(ip);
            systemLogEntity.setResult(JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat}));
            systemLogEntity.setUrl(SpringUtil.getRequest().getRequestURI());
            if (e != null) {
                systemLogEntity.setStatus(ERROR);
                systemLogEntity.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)4000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            systemLogEntity.setMethod(className + "." + methodName + "()");
            systemLogEntity.setRequestMethod(SpringUtil.getRequest().getMethod());
            systemLogEntity.setBusinessType(controllerLog.businessType().name().toLowerCase());
            systemLogEntity.setTitle(controllerLog.title());
            systemLogEntity.setUserType(controllerLog.operatorType().name().toLowerCase());
            if (controllerLog.isSaveRequestData()) {
                boolean isJson;
                boolean bl = isJson = StringUtils.isNotBlank((CharSequence)SpringUtil.getRequest().getContentType()) && MediaType.valueOf((String)SpringUtil.getRequest().getContentType()).includes(MediaType.APPLICATION_JSON);
                if (isJson) {
                    Object jsonParam = this.getJsonParam(joinPoint);
                    if (ObjectUtil.isNotNull((Object)jsonParam)) {
                        String jsonString = JSONObject.toJSONString((Object)jsonParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat});
                        systemLogEntity.setParam(StringUtils.substring((String)jsonString, (int)0, (int)4000));
                    }
                } else {
                    Map map = SpringUtil.getRequest().getParameterMap();
                    String params = JSONObject.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat});
                    systemLogEntity.setParam(StringUtils.substring((String)params, (int)0, (int)4000));
                }
            }
            systemLogEntity.setCreateDate(new Date());
            this.systemLogBiz.saveData(systemLogEntity);
        }
        catch (Exception exp) {
            LOG.error("\u65e5\u5fd7\u8bb0\u5f55\u9519\u8bef:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }
}

