/**
The MIT License (MIT) * Copyright (c) 2016 铭飞科技

 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package net.mingsoft.basic.biz.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.biz.IFileBiz;
import net.mingsoft.basic.dao.IFileDao;
import net.mingsoft.basic.entity.FileEntity;
import net.mingsoft.basic.util.BasicUtil;

/**
 * 基础文件表管理持久化层
 * @author 铭飞开发团队
 * 创建日期：2018-12-29 9:18:56<br/>
 * 历史修订：<br/>
 */
 @Service("fileBizImpl")
public class FileBizImpl extends BaseBizImpl implements IFileBiz {

	
	@Autowired
	private IFileDao fileDao;
	
	
		@Override
	protected IBaseDao getDao() {
		// TODO Auto-generated method stub
		return fileDao;
	} 
	@Override
	public int saveFile(FileEntity file) {
		file.setAppId(BasicUtil.getAppId());
		fileDao.saveEntity(file);
		return saveEntity(file);
	}


	@Override
	public void updateFile(FileEntity file) {
		file.setAppId(BasicUtil.getAppId());
		fileDao.updateEntity(file);
		updateEntity(file);
	}
}