package net.mingsoft.basic.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IFileBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.FileEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
/**
 * 基础文件表管理控制层
 * @author 铭飞开发团队
 * 创建日期：2018-12-29 9:18:56<br/>
 * 历史修订：<br/>
 */
@Api("基础文件表管理控制层")
@Controller("netFileAction")
@RequestMapping("/${ms.manager.path}/basic/file")
public class FileAction extends net.mingsoft.basic.action.BaseAction{


	/**
	 * 注入基础文件表业务层
	 */
	@Resource(name="fileBizImpl")
	private IFileBiz fileBiz;

	/**
	 * 返回主界面index
	 */
	@ApiOperation(value = "返回主界面index")
	@GetMapping("/index")
	public String index(HttpServletResponse response,HttpServletRequest request){
		return "/basic/file/index";
	}


	@ApiOperation(value = "查询基础文件表列表")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryId", value = "文件分类编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "fileName", value = "文件名称", required = false,paramType="query"),
		@ApiImplicitParam(name = "fileUrl", value = "文件链接", required = false,paramType="query"),
		@ApiImplicitParam(name = "fileSize", value = "文件大小", required = false,paramType="query"),
		@ApiImplicitParam(name = "fileJson", value = "文件详情Json数据", required = false,paramType="query"),
		@ApiImplicitParam(name = "fileType", value = "文件类型：图片、音频、视频等", required = false,paramType="query"),
		@ApiImplicitParam(name = "isChild", value = "子业务", required = false,paramType="query"),
	})
	@GetMapping("/list")
	@ResponseBody
	public ResultData list(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
		BasicUtil.startPage();
		List fileList = fileBiz.query(file);
		return ResultData.build().success(new EUListBean(fileList,(int)BasicUtil.endPage(fileList).getTotal()));
	}

	/**
	 * 返回编辑界面file_form
	 */
	@ApiOperation(value = "返回编辑界面file_form")
	@ApiImplicitParam(name = "id", value = "文件编号", required = true,paramType="query")
	@GetMapping("/form")
	public String form(@ModelAttribute @ApiIgnore FileEntity file,HttpServletResponse response,HttpServletRequest request,@ApiIgnore ModelMap model){
		if(file.getId()!=null){
			BaseEntity fileEntity = fileBiz.getEntity(Integer.parseInt(file.getId()));
			model.addAttribute("fileEntity",fileEntity);
		}
		return "/basic/file/form";
	}

	/**
	 * 获取基础文件表
	 * @param file 基础文件表实体
	 * <i>file参数包含字段信息参考：</i><br/>
	 * id 文件编号<br/>
	 * categoryId 文件分类编号<br/>
	 * appId APP编号<br/>
	 * fileName 文件名称<br/>
	 * fileUrl 文件链接<br/>
	 * fileSize 文件大小<br/>
	 * fileJson 文件详情Json数据<br/>
	 * fileType 文件类型：图片、音频、视频等<br/>
	 * isChild 子业务<br/>
	 * updateDate 更新时间<br/>
	 * updateBy 更新者<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * id: 文件编号<br/>
	 * categoryId: 文件分类编号<br/>
	 * appId: APP编号<br/>
	 * fileName: 文件名称<br/>
	 * fileUrl: 文件链接<br/>
	 * fileSize: 文件大小<br/>
	 * fileJson: 文件详情Json数据<br/>
	 * fileType: 文件类型：图片、音频、视频等<br/>
	 * isChild: 子业务<br/>
	 * updateDate: 更新时间<br/>
	 * updateBy: 更新者<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * del: 删除标记<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "获取基础文件表")
	@ApiImplicitParam(name = "id", value = "文件编号", required = true,paramType="query")
	@GetMapping("/get")
	@ResponseBody
	public ResultData get(@ModelAttribute @ApiIgnore FileEntity file,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model){
		if(file.getId()==null) {
			return null;
		}
		FileEntity _file = (FileEntity)fileBiz.getEntity(Integer.parseInt(file.getId()));
		return ResultData.build().success(_file);
	}

	/**
	 * 保存基础文件表实体
	 * @param file 基础文件表实体
	 * <i>file参数包含字段信息参考：</i><br/>
	 * id 文件编号<br/>
	 * categoryId 文件分类编号<br/>
	 * appId APP编号<br/>
	 * fileName 文件名称<br/>
	 * fileUrl 文件链接<br/>
	 * fileSize 文件大小<br/>
	 * fileJson 文件详情Json数据<br/>
	 * fileType 文件类型：图片、音频、视频等<br/>
	 * isChild 子业务<br/>
	 * updateDate 更新时间<br/>
	 * updateBy 更新者<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * id: 文件编号<br/>
	 * categoryId: 文件分类编号<br/>
	 * appId: APP编号<br/>
	 * fileName: 文件名称<br/>
	 * fileUrl: 文件链接<br/>
	 * fileSize: 文件大小<br/>
	 * fileJson: 文件详情Json数据<br/>
	 * fileType: 文件类型：图片、音频、视频等<br/>
	 * isChild: 子业务<br/>
	 * updateDate: 更新时间<br/>
	 * updateBy: 更新者<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * del: 删除标记<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "保存基础文件表实体")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryId", value = "文件分类编号", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileName", value = "文件名称", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileUrl", value = "文件链接", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileSize", value = "文件大小", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileJson", value = "文件详情Json数据", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileType", value = "文件类型：图片、音频、视频等", required = true,paramType="query"),
		@ApiImplicitParam(name = "isChild", value = "子业务", required = true,paramType="query"),
	})
	@LogAnn(title = "保存基础文件表实体",businessType= BusinessTypeEnum.INSERT)
	@PostMapping("/save")
	@ResponseBody
	@RequiresPermissions("file:save")
	public ResultData save(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request,BindingResult result) {
		//验证文件分类编号的值是否合法
		if(StringUtil.isBlank(file.getCategoryId())){
			return ResultData.build().error(getResString("err.empty", this.getResString("category.id")));
		}
		if(!StringUtil.checkLength(file.getCategoryId()+"", 1, 11)){
			return ResultData.build().error(getResString("err.length", this.getResString("category.id"), "1", "11"));
		}
		//验证文件名称的值是否合法
		if(StringUtil.isBlank(file.getFileName())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.name")));
		}
		if(!StringUtil.checkLength(file.getFileName()+"", 1, 200)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.name"), "1", "200"));
		}
		//验证文件链接的值是否合法
		if(StringUtil.isBlank(file.getFileUrl())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.url")));
		}
		if(!StringUtil.checkLength(file.getFileUrl()+"", 1, 500)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.url"), "1", "500"));
		}
		//验证文件大小的值是否合法
		if(StringUtil.isBlank(file.getFileSize())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.size")));
		}
		if(!StringUtil.checkLength(file.getFileSize()+"", 1, 11)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.size"), "1", "11"));
		}
		//验证文件详情Json数据的值是否合法
		if(StringUtil.isBlank(file.getFileJson())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.json")));
		}
		if(!StringUtil.checkLength(file.getFileJson()+"", 1, 500)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.json"), "1", "500"));
		}
		//验证文件类型：图片、音频、视频等的值是否合法
		if(StringUtil.isBlank(file.getFileType())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.type")));
		}
		if(!StringUtil.checkLength(file.getFileType()+"", 1, 50)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.type"), "1", "50"));
		}
		//验证子业务的值是否合法
		if(StringUtil.isBlank(file.getIsChild())){
			return ResultData.build().error(getResString("err.empty", this.getResString("is.child")));
		}
		if(!StringUtil.checkLength(file.getIsChild()+"", 1, 50)){
			return ResultData.build().error(getResString("err.length", this.getResString("is.child"), "1", "50"));
		}
		fileBiz.saveEntity(file);
		return ResultData.build().success(file);
	}

	/**
	 * @param files 基础文件表实体
	 * <i>file参数包含字段信息参考：</i><br/>
	 * id:多个id直接用逗号隔开,例如id=1,2,3,4
	 * 批量删除基础文件表
	 *            <dt><span class="strong">返回</span></dt><br/>
	 *            <dd>{code:"错误编码",<br/>
	 *            result:"true｜false",<br/>
	 *            resultMsg:"错误信息"<br/>
	 *            }</dd>
	 */
	@ApiOperation(value = "批量删除基础文件表")
	@LogAnn(title = "批量删除基础文件表",businessType= BusinessTypeEnum.DELETE)
	@PostMapping("/delete")
	@ResponseBody
	@RequiresPermissions("file:del")
	public ResultData delete(@RequestBody List<FileEntity> files,HttpServletResponse response, HttpServletRequest request) {
		int[] ids = new int[files.size()];
		for(int i = 0;i<files.size();i++){
			ids[i] =Integer.parseInt(files.get(i).getId()) ;
		}
		fileBiz.delete(ids);
		return ResultData.build().success();
	}

	/**
	 * 更新基础文件表信息基础文件表
	 * @param file 基础文件表实体
	 * <i>file参数包含字段信息参考：</i><br/>
	 * id 文件编号<br/>
	 * categoryId 文件分类编号<br/>
	 * appId APP编号<br/>
	 * fileName 文件名称<br/>
	 * fileUrl 文件链接<br/>
	 * fileSize 文件大小<br/>
	 * fileJson 文件详情Json数据<br/>
	 * fileType 文件类型：图片、音频、视频等<br/>
	 * isChild 子业务<br/>
	 * updateDate 更新时间<br/>
	 * updateBy 更新者<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * id: 文件编号<br/>
	 * categoryId: 文件分类编号<br/>
	 * appId: APP编号<br/>
	 * fileName: 文件名称<br/>
	 * fileUrl: 文件链接<br/>
	 * fileSize: 文件大小<br/>
	 * fileJson: 文件详情Json数据<br/>
	 * fileType: 文件类型：图片、音频、视频等<br/>
	 * isChild: 子业务<br/>
	 * updateDate: 更新时间<br/>
	 * updateBy: 更新者<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * del: 删除标记<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "更新基础文件表信息基础文件表")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "id", value = "文件编号", required = true,paramType="query"),
		@ApiImplicitParam(name = "categoryId", value = "文件分类编号", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileName", value = "文件名称", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileUrl", value = "文件链接", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileSize", value = "文件大小", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileJson", value = "文件详情Json数据", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileType", value = "文件类型：图片、音频、视频等", required = true,paramType="query"),
		@ApiImplicitParam(name = "isChild", value = "子业务", required = true,paramType="query"),
	})
	@LogAnn(title = "更新基础文件表信息基础文件表",businessType= BusinessTypeEnum.UPDATE)
	@PostMapping("/update")
	@ResponseBody
	@RequiresPermissions("file:update")
	public ResultData update(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response,
			HttpServletRequest request) {
		//验证文件编号的值是否合法
		if(StringUtil.isBlank(file.getId())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.id")));
		}
		if(!StringUtil.checkLength(file.getId()+"", 1, 11)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.id"), "1", "11"));
		}
		//验证文件分类编号的值是否合法
		if(StringUtil.isBlank(file.getCategoryId())){
			return ResultData.build().error(getResString("err.empty", this.getResString("category.id")));
		}
		if(!StringUtil.checkLength(file.getCategoryId()+"", 1, 11)){
			return ResultData.build().error(getResString("err.length", this.getResString("category.id"), "1", "11"));
		}
		//验证文件名称的值是否合法
		if(StringUtil.isBlank(file.getFileName())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.name")));
		}
		if(!StringUtil.checkLength(file.getFileName()+"", 1, 200)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.name"), "1", "200"));
		}
		//验证文件链接的值是否合法
		if(StringUtil.isBlank(file.getFileUrl())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.url")));
		}
		if(!StringUtil.checkLength(file.getFileUrl()+"", 1, 500)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.url"), "1", "500"));
		}
		//验证文件大小的值是否合法
		if(StringUtil.isBlank(file.getFileSize())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.size")));
		}
		if(!StringUtil.checkLength(file.getFileSize()+"", 1, 11)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.size"), "1", "11"));
		}
		//验证文件详情Json数据的值是否合法
		if(StringUtil.isBlank(file.getFileJson())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.json")));
		}
		if(!StringUtil.checkLength(file.getFileJson()+"", 1, 500)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.json"), "1", "500"));
		}
		//验证文件类型：图片、音频、视频等的值是否合法
		if(StringUtil.isBlank(file.getFileType())){
			return ResultData.build().error(getResString("err.empty", this.getResString("file.type")));
		}
		if(!StringUtil.checkLength(file.getFileType()+"", 1, 50)){
			return ResultData.build().error(getResString("err.length", this.getResString("file.type"), "1", "50"));
		}
		//验证子业务的值是否合法
		if(StringUtil.isBlank(file.getIsChild())){
			return ResultData.build().error(getResString("err.empty", this.getResString("is.child")));
		}
		if(!StringUtil.checkLength(file.getIsChild()+"", 1, 50)){
			return ResultData.build().error(getResString("err.length", this.getResString("is.child"), "1", "50"));
		}
		fileBiz.updateEntity(file);
		return ResultData.build().success(file);
	}

}
