<script id="v-echarts" type="x/template">
    <div id="chart" ref="chart" :style="'width:'+width+';height:'+height"></div>
</script>
<script>
    Vue.component("v-chart", {
        template: "#v-echarts",
        props:{
            option:{
                type: Object,
                default: ()=>{ return {} }
            },
        },
        data() {
            return {
                chart:{},
                width:'600px',
                height: '400px',
            }
        },
        watch:{
            option: function(n){
                if(n){
                    this.init();
                    this.initSize();
                }
            }
        },
        methods: {
            //初始化
            init: function(){
                this.chart = echarts.init(this.$refs.chart);
                this.chart.setOption(this.option);
            },
            //自适应容器大小
            initSize: function(){
                this.width = this.$refs.chart.parentNode.offsetWidth;
                this.height = this.$refs.chart.parentNode.offsetHeight;
                this.chart.resize();
            },
        },
        mounted(){
            window.onresize = () => {
                this.initSize();
            }
        }
    });
</script>