/**
The MIT License (MIT) * Copyright (c) 2016 铭飞科技(mingsoft.net)

 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package net.mingsoft.basic.servlet;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;

import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.base.constant.Const;



/**
 * CMS系统分发serlvet,根据地址栏判断网站来源,
 * 注意：每个网站的静态文件必须加上网站绝对地址。例如：http://www.abc.com/html/abc.html
 */

@WebServlet("/index")
public class IndexServlet extends HttpServlet {

	private static final long serialVersionUID = -7580260477467138079L;

	private static String  INDEX = "index.html", DEFAULT = "default.html";

	/**
	 * 注入站点业务层
	 */
	private IAppBiz appBiz;

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		// 获取用户所请求的域名地址

		appBiz = SpringUtil.getBean(IAppBiz.class);
		// 查询数据库获取域名对应Id
		int websiteId = 0;
		AppEntity website = appBiz.getByUrl(BasicUtil.getDomain());
		if (website != null) {
			websiteId = website.getAppId();
		} else {
			return;
		}
		String path = "";

		if (!StringUtils.isEmpty(website.getAppMobileStyle())) {
			path = BasicUtil.isMobileDevice() ? "m" : ""; // 如果是手机访问就跳转到相应页面
		}

		String defaultHtmlPath = BasicUtil.getRealPath("html" + File.separator + websiteId + File.separator + path + File.separator + "default.html");
		File file = new File(defaultHtmlPath);
		String url = "html" + Const.SEPARATOR + websiteId + Const.SEPARATOR + path;
		String indexPosition = url + Const.SEPARATOR + INDEX;
		if (file.exists()) {
			indexPosition = url + Const.SEPARATOR + DEFAULT;
		}
		// 转发到网站首页
		request.getRequestDispatcher(indexPosition).forward(request, response);

	}

}