package net.mingsoft.basic.action;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;

import cn.hutool.crypto.SecureUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import springfox.documentation.annotations.ApiIgnore;
	
/**
 * 管理员管理控制层
 * @author 铭飞开发团队
 * @version 
 * 版本号：1.0<br/>
 * 创建日期：2017-8-24 23:40:55<br/>
 * 历史修订：<br/>
 */
@Api(value = "管理员管理接口")
@Controller
@RequestMapping("/${ms.manager.path}/basic/manager")
public class ManagerAction extends net.mingsoft.basic.action.BaseAction{
	
	/**
	 * 注入管理员业务层
	 */	
	@Autowired
	private IManagerBiz managerBiz;
	
	/**
	 * 返回主界面index
	 */
	@GetMapping("/index")
	public String index(HttpServletResponse response,HttpServletRequest request){
		return "/basic/manager/index";
	}
	
	/**
	 * 查询管理员列表
	 * @param manager 管理员实体
	 * <i>manager参数包含字段信息参考：</i><br/>
	 * managerId 管理员ID(主键)<br/>
	 * managerName 管理员用户名<br/>
	 * managerNickname 管理员昵称<br/>
	 * managerPassword 管理员密码<br/>
	 * managerRoleid 角色编号<br/>
	 * managerPeopleid 用户编号即商家编号<br/>
	 * managerTime 管理员创建时间<br/>
	 * managerSystemSkinId 管理员主界面样式<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>[<br/>
	 * { <br/>
	 * managerId: 管理员ID(主键)<br/>
	 * managerName: 管理员用户名<br/>
	 * managerNickname: 管理员昵称<br/>
	 * managerPassword: 管理员密码<br/>
	 * managerRoleid: 角色编号<br/>
	 * managerPeopleid: 用户编号即商家编号<br/>
	 * managerTime: 管理员创建时间<br/>
	 * managerSystemSkinId: 管理员主界面样式<br/>
	 * }<br/>
	 * ]</dd><br/>	 
	 */
	@ApiOperation(value = "查询管理员列表")
	@GetMapping("/list")
	@ResponseBody
	public void list(@ModelAttribute @ApiIgnore ManagerEntity manager,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model) {
		ManagerSessionEntity managerSession = getManagerBySession(request);
		BasicUtil.startPage();
		List managerList = managerBiz.queryAllChildManager(managerSession.getManagerId());
		this.outJson(response, net.mingsoft.base.util.JSONArray.toJSONString(new EUListBean(managerList,(int)BasicUtil.endPage(managerList).getTotal()),new DoubleValueFilter(),new DateValueFilter()));
	}
	/**
	 * 查询管理员列表,去掉当前管理员id，确保不能删除和修改自己
	 * @param manager 管理员实体
	 * <i>manager参数包含字段信息参考：</i><br/>
	 * managerId 管理员ID(主键)<br/>
	 * managerName 管理员用户名<br/>
	 * managerNickname 管理员昵称<br/>
	 * managerPassword 管理员密码<br/>
	 * managerRoleid 角色编号<br/>
	 * managerPeopleid 用户编号即商家编号<br/>
	 * managerTime 管理员创建时间<br/>
	 * managerSystemSkinId 管理员主界面样式<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>[<br/>
	 * { <br/>
	 * managerId: 管理员ID(主键)<br/>
	 * managerName: 管理员用户名<br/>
	 * managerNickname: 管理员昵称<br/>
	 * managerPassword: 管理员密码<br/>
	 * managerRoleid: 角色编号<br/>
	 * managerPeopleid: 用户编号即商家编号<br/>
	 * managerTime: 管理员创建时间<br/>
	 * managerSystemSkinId: 管理员主界面样式<br/>
	 * }<br/>
	 * ]</dd><br/>	 
	 */
	@ApiOperation(value = "查询管理员列表,去掉当前管理员id，确保不能删除和修改自己")
	@GetMapping("/query")
	@ResponseBody
	public void query(HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model) {
		ManagerSessionEntity managerSession = getManagerBySession(request);
		BasicUtil.startPage();
		List<ManagerEntity> managerList = managerBiz.queryAllChildManager(managerSession.getManagerId());
		for(ManagerEntity _manager : managerList){
			if(_manager.getManagerId() == managerSession.getManagerId()){
				_manager.setManagerId(0);
			}
		}
		this.outJson(response, net.mingsoft.base.util.JSONArray.toJSONString(new EUListBean(managerList,(int)BasicUtil.endPage(managerList).getTotal()),new DoubleValueFilter(),new DateValueFilter()));
	}
	/**
	 * 获取管理员
	 * @param manager 管理员实体
	 * <i>manager参数包含字段信息参考：</i><br/>
	 * managerId 管理员ID(主键)<br/>
	 * managerName 管理员用户名<br/>
	 * managerNickname 管理员昵称<br/>
	 * managerPassword 管理员密码<br/>
	 * managerRoleid 角色编号<br/>
	 * managerPeopleid 用户编号即商家编号<br/>
	 * managerTime 管理员创建时间<br/>
	 * managerSystemSkinId 管理员主界面样式<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * managerId: 管理员ID(主键)<br/>
	 * managerName: 管理员用户名<br/>
	 * managerNickname: 管理员昵称<br/>
	 * managerPassword: 管理员密码<br/>
	 * managerRoleid: 角色编号<br/>
	 * managerPeopleid: 用户编号即商家编号<br/>
	 * managerTime: 管理员创建时间<br/>
	 * managerSystemSkinId: 管理员主界面样式<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value="获取管理员接口")
	@GetMapping("/get")
	@ResponseBody
	public void get(@ModelAttribute @ApiIgnore ManagerEntity manager,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model){
		ManagerEntity managerEntity = new ManagerEntity();
		//判断是否传managerId
		if(manager.getManagerId() > 0){
			managerEntity = (ManagerEntity)managerBiz.getEntity(manager.getManagerId());
		}else{
			ManagerEntity managerSession = (ManagerEntity) BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION);
			managerEntity = (ManagerEntity)managerBiz.getEntity(managerSession.getManagerId());
		}
		managerEntity.setManagerPassword("");
		this.outJson(response, managerEntity);
	}
	
	/**
	 * 保存管理员实体
	 * @param manager 管理员实体
	 * <i>manager参数包含字段信息参考：</i><br/>
	 * managerId 管理员ID(主键)<br/>
	 * managerName 管理员用户名<br/>
	 * managerNickname 管理员昵称<br/>
	 * managerPassword 管理员密码<br/>
	 * managerRoleid 角色编号<br/>
	 * managerPeopleid 用户编号即商家编号<br/>
	 * managerTime 管理员创建时间<br/>
	 * managerSystemSkinId 管理员主界面样式<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * managerId: 管理员ID(主键)<br/>
	 * managerName: 管理员用户名<br/>
	 * managerNickname: 管理员昵称<br/>
	 * managerPassword: 管理员密码<br/>
	 * managerRoleid: 角色编号<br/>
	 * managerPeopleid: 用户编号即商家编号<br/>
	 * managerTime: 管理员创建时间<br/>
	 * managerSystemSkinId: 管理员主界面样式<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "保存管理员实体")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "managerName", value = "帐号", required = true,paramType="query"),
		@ApiImplicitParam(name = "managerNickName", value = "昵称", required = true,paramType="query"),
		@ApiImplicitParam(name = "managerPassword", value = "密码", required = true,paramType="query"),
		@ApiImplicitParam(name = "managerRoleID", value = "角色ID", required = false,paramType="query"),
		@ApiImplicitParam(name = "managerPeopleID", value = "用户ID", required = false,paramType="query"),
	})
	@PostMapping("/save")
	@ResponseBody
	@RequiresPermissions("manager:save")
	public void save(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
		ManagerEntity newManager = new ManagerEntity();
		newManager.setManagerName(manager.getManagerName());
		//用户名是否存在
		if(managerBiz.getEntity(newManager) != null){
			this.outJson(response, null,false,getResString("err.exist", this.getResString("manager.name")));
			return;
		}
		//验证管理员用户名的值是否合法			
		if(StringUtil.isBlank(manager.getManagerName())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("manager.name")));
			return;			
		}
		if(!StringUtil.checkLength(manager.getManagerName()+"", 1, 15)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("manager.name"), "1", "15"));
			return;			
		}
		//验证管理员昵称的值是否合法			
		if(StringUtil.isBlank(manager.getManagerNickName())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("manager.nickname")));
			return;			
		}
		if(!StringUtil.checkLength(manager.getManagerNickName()+"", 1, 15)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("manager.nickname"), "1", "15"));
			return;			
		}
		//验证管理员密码的值是否合法
		if(StringUtil.isBlank(manager.getManagerPassword())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("manager.password")));
			return;			
		}
		if(!StringUtil.checkLength(manager.getManagerPassword()+"", 1, 45)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("manager.password"), "1", "45"));
			return;			
		}
		manager.setManagerPassword(SecureUtil.md5(manager.getManagerPassword()));
		manager.setManagerTime(new Date());
		managerBiz.saveEntity(manager);
		this.outJson(response, JSONObject.toJSONString(manager));
	}
	
	/**
	 * @param manager 管理员实体
	 * <i>manager参数包含字段信息参考：</i><br/>
	 * managerId:多个managerId直接用逗号隔开,例如managerId=1,2,3,4
	 * 批量删除管理员
	 *            <dt><span class="strong">返回</span></dt><br/>
	 *            <dd>{code:"错误编码",<br/>
	 *            result:"true｜false",<br/>
	 *            resultMsg:"错误信息"<br/>
	 *            }</dd>
	 */
	@ApiOperation(value = "批量删除管理员")
	@PostMapping("/delete")
	@ResponseBody
	@RequiresPermissions("manager:del")
	public void delete(@RequestBody List<ManagerEntity> managers,HttpServletResponse response, HttpServletRequest request) {
		int[] ids = new int[managers.size()];
		for(int i = 0;i<managers.size();i++){
			ids[i] = managers.get(i).getManagerId();
		}
		managerBiz.delete(ids);		
		this.outJson(response, true);
	}
	
	/** 
	 * 更新管理员信息管理员
	 * @param manager 管理员实体
	 * <i>manager参数包含字段信息参考：</i><br/>
	 * managerId 管理员ID(主键)<br/>
	 * managerName 管理员用户名<br/>
	 * managerNickname 管理员昵称<br/>
	 * managerPassword 管理员密码<br/>
	 * managerRoleid 角色编号<br/>
	 * managerPeopleid 用户编号即商家编号<br/>
	 * managerTime 管理员创建时间<br/>
	 * managerSystemSkinId 管理员主界面样式<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * managerId: 管理员ID(主键)<br/>
	 * managerName: 管理员用户名<br/>
	 * managerNickname: 管理员昵称<br/>
	 * managerPassword: 管理员密码<br/>
	 * managerRoleid: 角色编号<br/>
	 * managerPeopleid: 用户编号即商家编号<br/>
	 * managerTime: 管理员创建时间<br/>
	 * managerSystemSkinId: 管理员主界面样式<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "更新管理员信息管理员")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "managerName", value = "帐号", required = true,paramType="query"),
		@ApiImplicitParam(name = "managerNickName", value = "昵称", required = true,paramType="query"),
		@ApiImplicitParam(name = "managerPassword", value = "密码", required = true,paramType="query"),
		@ApiImplicitParam(name = "managerRoleID", value = "角色ID", required = false,paramType="query"),
		@ApiImplicitParam(name = "managerPeopleID", value = "用户ID", required = false,paramType="query"),
	})
	@PostMapping("/update")
	@ResponseBody
	@RequiresPermissions("manager:update")
	public void update(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response,
			HttpServletRequest request) {	
		ManagerEntity newManager = new ManagerEntity();
		newManager.setManagerName(manager.getManagerName());
		
		ManagerEntity _manager = (ManagerEntity) managerBiz.getEntity(newManager);
		//用户名是否存在
		if(_manager != null){
		    if(manager.getManagerId() != _manager.getManagerId()){
			    this.outJson(response, null,false,getResString("err.exist", this.getResString("manager.name")));
			    return;
		    }
		}
		//验证管理员用户名的值是否合法			
		if(StringUtil.isBlank(manager.getManagerName())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("manager.name")));
			return;			
		}
		if(!StringUtil.checkLength(manager.getManagerName()+"", 1, 15)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("manager.name"), "1", "15"));
			return;			
		}
		//验证管理员昵称的值是否合法			
		if(StringUtil.isBlank(manager.getManagerNickName())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("manager.nickname")));
			return;			
		}
		if(!StringUtil.checkLength(manager.getManagerNickName()+"", 1, 15)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("manager.nickname"), "1", "15"));
			return;			
		}
		//验证管理员密码的值是否合法
		if(!StringUtil.isBlank(manager.getManagerPassword())){
			if(!StringUtil.checkLength(manager.getManagerPassword()+"", 1, 45)){
				this.outJson(response, null, false, getResString("err.length", this.getResString("manager.password"), "1", "45"));
				return;			
			}	
			manager.setManagerPassword(SecureUtil.md5(manager.getManagerPassword()));
		}
		
		managerBiz.updateEntity(manager);
		this.outJson(response, JSONObject.toJSONString(manager));
	}
		
}