

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `app`
-- ----------------------------
DROP TABLE IF EXISTS `app`;
CREATE TABLE `app` (
`app_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '站点id' ,
`app_name`  varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站点名称' ,
`app_url`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站点域名，多个回车换行显示' ,
`app_logo`  varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '网站logo' ,
`app_keyword`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站点关键字' ,
`app_copyright`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站点版权信息' ,
`app_style`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '站点风格' ,
`app_managerid`  int(11) NULL DEFAULT NULL COMMENT '站点对于管理员编号' ,
`app_description`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述' ,
`app_datetime`  datetime NULL DEFAULT NULL COMMENT '创建时间' ,
`app_mobile_style`  varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '移动端风格' ,
`app_pay_date`  datetime NULL DEFAULT NULL COMMENT '应用续费时间' ,
`app_pay`  varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '费用清单' ,
`app_state`  int(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '0运行中 1已停止  ' ,
`app_mobile_state`  int(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '0启用 1停用' ,
`app_login_page`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`app_id`),
FOREIGN KEY (`app_managerid`) REFERENCES `manager` (`manager_id`) ON DELETE SET NULL ON UPDATE NO ACTION,
INDEX `fk_app_manager_1` (`app_managerid`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='应用表'
AUTO_INCREMENT=2

;

-- ----------------------------
-- Table structure for `basic`
-- ----------------------------
DROP TABLE IF EXISTS `basic`;
CREATE TABLE `basic` (
`basic_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长id' ,
`basic_title`  varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标题' ,
`basic_description`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述' ,
`basic_thumbnails`  varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '缩略图' ,
`basic_hit`  bigint(22) NULL DEFAULT 0 COMMENT '点击次数' ,
`basic_sort`  int(11) NULL DEFAULT NULL COMMENT '排序' ,
`basic_datetime`  datetime NULL DEFAULT NULL COMMENT ' 发布时间' ,
`basic_updatetime`  datetime NULL DEFAULT NULL COMMENT '更新时间' ,
`basic_peopleid`  int(22) NULL DEFAULT NULL COMMENT '用户编号' ,
`basic_categoryid`  int(22) NULL DEFAULT NULL COMMENT '所属分类编号' ,
`basic_appid`  int(11) NOT NULL COMMENT '应用编号' ,
`basic_modelid`  int(11) NULL DEFAULT NULL COMMENT '模块编号' ,
`basic_comment`  int(11) NULL DEFAULT 0 COMMENT '评论次数' ,
`basic_collect`  int(11) NULL DEFAULT 0 COMMENT '收藏次数' ,
`basic_share`  int(11) NULL DEFAULT 0 COMMENT '分享次数' ,
`basic_type`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '属性' ,
`basic_display`  int(1) NULL DEFAULT 0 COMMENT '文章是否显示' ,
PRIMARY KEY (`basic_id`),
FOREIGN KEY (`basic_appid`) REFERENCES `app` (`app_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`basic_categoryid`) REFERENCES `category` (`category_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
UNIQUE INDEX `basic_id` (`basic_id`) USING BTREE ,
INDEX `basic_appid` (`basic_appid`) USING BTREE ,
INDEX `basic_modelid` (`basic_modelid`) USING BTREE ,
INDEX `basic_categoryid` (`basic_categoryid`) USING BTREE ,
INDEX `basic_title` (`basic_title`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='基础表'
AUTO_INCREMENT=1211261

;

-- ----------------------------
-- Table structure for `basic_attention`
-- ----------------------------
DROP TABLE IF EXISTS `basic_attention`;
CREATE TABLE `basic_attention` (
`ba_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长id' ,
`ba_people_id`  int(11) NULL DEFAULT NULL COMMENT '用户id' ,
`ba_app_id`  int(11) NULL DEFAULT NULL COMMENT '用户应用id' ,
`ba_basic_id`  int(11) NULL DEFAULT NULL COMMENT '用户收藏关联的基础id' ,
`ba_type`  int(11) NULL DEFAULT NULL COMMENT '收藏类型 1： 收藏  2：顶' ,
`ba_datetime`  datetime NULL DEFAULT NULL COMMENT '用户收藏文章，帖子或商品时的时间' ,
`ba_url`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '收藏的文章,帖子，商品的链接地址' ,
PRIMARY KEY (`ba_id`),
FOREIGN KEY (`ba_basic_id`) REFERENCES `basic` (`basic_id`) ON DELETE CASCADE ON UPDATE RESTRICT,
INDEX `fk_basic_attention_basic_1` (`ba_basic_id`) USING BTREE ,
INDEX `ba_people_id` (`ba_people_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='用户收藏表'
AUTO_INCREMENT=1017

;

-- ----------------------------
-- Table structure for `basic_column`
-- ----------------------------
DROP TABLE IF EXISTS `basic_column`;
CREATE TABLE `basic_column` (
`column_category_id`  int(11) NOT NULL COMMENT '关联category表（类别表ID）' ,
`column_keyword`  varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '栏目简介' ,
`column_descrip`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '栏目关键字的扩展' ,
`column_type`  int(2) NULL DEFAULT NULL COMMENT '1,代表最终列表栏目。2，代表频道封面。3，带表外部链接' ,
`column_url`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '如果是外部链接，则保持外部链接地址。如果为最终列表栏目，就保存文章显示列表' ,
`column_listurl`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '最终列表栏目的列表模板地址' ,
`column_path`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '栏目路径' ,
`column_cm_id`  int(11) NULL DEFAULT NULL COMMENT '栏目管理的内容模型id' ,
`column_flag`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '栏目属性' ,
`column_diy_url`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '自定义链接' ,
PRIMARY KEY (`column_category_id`),
FOREIGN KEY (`column_cm_id`) REFERENCES `mdiy_content_model` (`cm_id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`column_category_id`) REFERENCES `category` (`category_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
INDEX `fk_basic_column_id` (`column_cm_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='栏目表'

;

-- ----------------------------
-- Table structure for `basic_log`
-- ----------------------------
DROP TABLE IF EXISTS `basic_log`;
CREATE TABLE `basic_log` (
`bl_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '编号' ,
`bl_basic_id`  int(11) NOT NULL COMMENT '引用编号' ,
`bl_ip`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ip地址' ,
`bl_datetime`  datetime NOT NULL COMMENT '记录时间' ,
`bl_is_mobile`  int(1) NOT NULL DEFAULT 0 COMMENT '1移动端 0默认pc' ,
PRIMARY KEY (`bl_id`),
FOREIGN KEY (`bl_basic_id`) REFERENCES `basic` (`basic_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
INDEX `fk_basic_log_basic_1` (`bl_basic_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='信息访问日志'
AUTO_INCREMENT=220

;

-- ----------------------------
-- Table structure for `category`
-- ----------------------------
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
`category_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '类别ID' ,
`category_title`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类别标题' ,
`category_sort`  int(10) NULL DEFAULT NULL COMMENT '类别排序' ,
`category_datetime`  datetime NULL DEFAULT NULL COMMENT '类别发布时间' ,
`category_managerid`  int(22) NULL DEFAULT NULL COMMENT '发布用户id' ,
`category_modelid`  int(11) NULL DEFAULT NULL COMMENT '所属模块id' ,
`category_categoryid`  int(11) NULL DEFAULT NULL COMMENT '父类别编号' ,
`category_smallimg`  varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '略缩图' ,
`category_appid`  int(11) NULL DEFAULT NULL COMMENT '应用编号' ,
`category_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '栏目描述' ,
`category_parent_id`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父类型编号' ,
`category_dict_id`  int(11) NULL DEFAULT 0 COMMENT '字典对应编号' ,
`create_by`  int(11) NULL DEFAULT 0 COMMENT '创建人' ,
`create_date`  datetime NULL DEFAULT NULL COMMENT '创建时间' ,
`update_by`  int(11) NULL DEFAULT 0 COMMENT '更新人' ,
`update_date`  datetime NULL DEFAULT NULL COMMENT '更新时间' ,
`del`  int(11) NOT NULL DEFAULT 0 COMMENT '删除状态' ,
PRIMARY KEY (`category_id`),
FOREIGN KEY (`category_appid`) REFERENCES `app` (`app_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`category_categoryid`) REFERENCES `category` (`category_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
INDEX `category_appid` (`category_appid`) USING BTREE ,
INDEX `category_managerid` (`category_managerid`) USING BTREE ,
INDEX `category_modelid` (`category_modelid`) USING BTREE ,
INDEX `category_categoryid` (`category_categoryid`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='分类表'
AUTO_INCREMENT=546

;

-- ----------------------------
-- Table structure for `city`
-- ----------------------------
DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
`id`  int(11) NOT NULL AUTO_INCREMENT ,
`province_id`  bigint(20) UNSIGNED NOT NULL ,
`province_name`  char(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`city_id`  bigint(20) UNSIGNED NOT NULL ,
`city_name`  char(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`county_id`  bigint(20) UNSIGNED NOT NULL ,
`county_name`  char(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`town_id`  bigint(20) UNSIGNED NOT NULL ,
`town_name`  char(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`village_id`  bigint(20) UNSIGNED NOT NULL ,
`village_name`  char(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`id`),
INDEX `province_id` (`province_id`) USING BTREE ,
INDEX `city_id` (`city_id`) USING BTREE ,
INDEX `county_id` (`county_id`) USING BTREE ,
INDEX `town_id` (`town_id`) USING BTREE ,
INDEX `village_id` (`village_id`) USING BTREE ,
INDEX `id` (`id`) USING BTREE 
)
ENGINE=MyISAM
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='省市县镇村数据'
AUTO_INCREMENT=668390

;

-- ----------------------------
-- Table structure for `manager`
-- ----------------------------
DROP TABLE IF EXISTS `manager`;
CREATE TABLE `manager` (
`manager_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '管理员id(主键)' ,
`manager_name`  varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理员用户名' ,
`manager_nickname`  varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理员昵称' ,
`manager_password`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理员密码' ,
`manager_roleid`  int(11) NULL DEFAULT NULL COMMENT '角色编号' ,
`manager_peopleid`  bigint(22) NULL DEFAULT 0 COMMENT '用户编号即商家编号' ,
`manager_time`  datetime NULL DEFAULT NULL COMMENT '管理员创建时间' ,
`manager_system_skin_id`  int(11) NULL DEFAULT 0 COMMENT '管理员主界面样式' ,
PRIMARY KEY (`manager_id`),
FOREIGN KEY (`manager_roleid`) REFERENCES `role` (`role_id`) ON DELETE SET NULL ON UPDATE NO ACTION,
INDEX `fk_manager_role_1` (`manager_roleid`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='管理员表'
AUTO_INCREMENT=54

;

-- ----------------------------
-- Table structure for `manager_model_page`
-- ----------------------------
DROP TABLE IF EXISTS `manager_model_page`;
CREATE TABLE `manager_model_page` (
`mmp_manager_id`  int(11) NULL DEFAULT NULL COMMENT '自增长id' ,
`mmp_model_id`  int(11) NULL DEFAULT NULL COMMENT '模块编号' ,
`mmp_url`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '默认后台显示的主界面' ,
FOREIGN KEY (`mmp_manager_id`) REFERENCES `manager` (`manager_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`mmp_model_id`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
INDEX `fk_manager_model_page_manager_1` (`mmp_manager_id`) USING BTREE ,
INDEX `fk_manager_model_page_model_1` (`mmp_model_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='管理员对应的每个模块的主界面自定义'

;

-- ----------------------------
-- Table structure for `model`
-- ----------------------------
DROP TABLE IF EXISTS `model`;
CREATE TABLE `model` (
`model_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '模块自增长id' ,
`model_title`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块标题' ,
`model_code`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块编码' ,
`model_modelid`  int(22) NULL DEFAULT NULL COMMENT '模块的父模块id' ,
`model_url`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块连接地址' ,
`model_datetime`  datetime NULL DEFAULT NULL ,
`model_icon`  varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块图标' ,
`model_modelmanagerid`  int(11) NULL DEFAULT NULL COMMENT '模块关联的关联员id' ,
`model_sort`  int(11) NULL DEFAULT NULL COMMENT '模块的排序' ,
`model_ismenu`  int(1) NULL DEFAULT NULL COMMENT '模块是否是菜单' ,
`model_parent_ids`  varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级编号集合，从小到大排序' ,
`IS_CHILD`  varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单类型' ,
PRIMARY KEY (`model_id`),
FOREIGN KEY (`model_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`model_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`model_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`model_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`model_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`model_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
UNIQUE INDEX `sys_c009201` (`model_id`) USING BTREE ,
INDEX `model_modelid` (`model_modelid`) USING BTREE ,
INDEX `model_code` (`model_code`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='模块表'
AUTO_INCREMENT=404

;

-- ----------------------------
-- Table structure for `role`
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
`role_id`  int(11) NOT NULL AUTO_INCREMENT COMMENT '角色id，自增长' ,
`role_name`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色名' ,
`role_managerid`  int(11) NULL DEFAULT 0 COMMENT '角色管理员编号' ,
`app_id`  int(11) NOT NULL COMMENT '应用编号' ,
PRIMARY KEY (`role_id`),
FOREIGN KEY (`app_id`) REFERENCES `app` (`app_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
INDEX `role_managerid` (`role_managerid`) USING BTREE ,
INDEX `fk_role_app_id` (`app_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='角色表'
AUTO_INCREMENT=50

;

-- ----------------------------
-- Table structure for `role_model`
-- ----------------------------
DROP TABLE IF EXISTS `role_model`;
CREATE TABLE `role_model` (
`rm_modelid`  int(22) NULL DEFAULT NULL COMMENT '模块编号' ,
`rm_roleid`  int(22) NULL DEFAULT NULL COMMENT '角色编号' ,
FOREIGN KEY (`rm_roleid`) REFERENCES `role` (`role_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`rm_modelid`) REFERENCES `model` (`model_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
UNIQUE INDEX `index` (`rm_modelid`, `rm_roleid`) USING BTREE ,
INDEX `rm_modelid` (`rm_modelid`) USING BTREE ,
INDEX `fk_role_model_role_1` (`rm_roleid`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
COMMENT='角色模块关联表'

;

-- ----------------------------
-- Auto increment value for `app`
-- ----------------------------
ALTER TABLE `app` AUTO_INCREMENT=2;

-- ----------------------------
-- Auto increment value for `basic`
-- ----------------------------
ALTER TABLE `basic` AUTO_INCREMENT=1211261;

-- ----------------------------
-- Auto increment value for `basic_attention`
-- ----------------------------
ALTER TABLE `basic_attention` AUTO_INCREMENT=1017;

-- ----------------------------
-- Auto increment value for `basic_log`
-- ----------------------------
ALTER TABLE `basic_log` AUTO_INCREMENT=220;

-- ----------------------------
-- Auto increment value for `category`
-- ----------------------------
ALTER TABLE `category` AUTO_INCREMENT=546;

-- ----------------------------
-- Auto increment value for `city`
-- ----------------------------
ALTER TABLE `city` AUTO_INCREMENT=668390;

-- ----------------------------
-- Auto increment value for `manager`
-- ----------------------------
ALTER TABLE `manager` AUTO_INCREMENT=54;

-- ----------------------------
-- Auto increment value for `model`
-- ----------------------------
ALTER TABLE `model` AUTO_INCREMENT=404;

-- ----------------------------
-- Auto increment value for `role`
-- ----------------------------
ALTER TABLE `role` AUTO_INCREMENT=50;
