package net.mingsoft.basic.action;


import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import net.mingsoft.basic.biz.IColumnBiz;
import net.mingsoft.basic.constant.Const;
import net.mingsoft.basic.constant.ModelCode;
import net.mingsoft.basic.entity.ColumnEntity;

import cn.hutool.core.io.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import springfox.documentation.annotations.ApiIgnore;



/**
 * 铭飞MS平台，通用栏目分类
 * @author 铭飞开发团队
 * @version 
 * 版本号：100-000-000<br/>
 * 创建日期：2017年8月9日<br/>
 * 历史修订：<br/>
 */
@Api("通用栏目分类")
@Controller("basicColumnAction")
@RequestMapping("/${ms.manager.path}/column")
public class ColumnAction extends BaseAction{
	
	
	/**
	 * 栏目业务层
	 */
	@Autowired
	private IColumnBiz columnBiz;
	
	
	/**
	 * 返回主界面index
	 */
	@ApiOperation(value = "返回主界面index")
	@GetMapping("/index")
	public String index(HttpServletResponse response,HttpServletRequest request,ModelMap model){
		return "/basic/column/index";
	}
	/**
	 * 栏目添加跳转页面
	 * 
	 * @return
	 */
	@ApiOperation(value = "栏目添加跳转页面")
	@GetMapping("/add")
	public String add(HttpServletRequest request,ModelMap model) {
		// 站点ID
		int appId = BasicUtil.getAppId();
		List<ColumnEntity> list = columnBiz.queryAll(appId, this.getModelCodeId(request));
		ColumnEntity columnSuper = new ColumnEntity();
		model.addAttribute("appId",appId);
		model.addAttribute("columnSuper", columnSuper);
		model.addAttribute("column",new ColumnEntity());
		model.addAttribute("listColumn", JSONArray.toJSONString(list));
		return "/basic/column/form";
	}

	/**
	 * 后台验证填写的栏目信息是否合法
	 * @param column  栏目信息
	 * @param response
	 * @return false:不合法 true:合法
	 */
	protected boolean checkForm(ColumnEntity column, HttpServletResponse response){
		//栏目标题空值验证
		if(StringUtil.isBlank(column.getCategoryTitle())){
			this.outJson( response, ModelCode.COLUMN, false, getResString("err.empty", this.getResString("categoryTitle")));
			return false;
		}
		//栏目标题长度验证
		if(!StringUtil.checkLength(column.getCategoryTitle(), 1, 31)){
			this.outJson( response, ModelCode.COLUMN, false, getResString("err.length", this.getResString("categoryTitle"), "1", "30"));
			return false;
		}
		//栏目属性空值验证
		if(StringUtil.isBlank(column.getColumnType()+"")){
			this.outJson( response, ModelCode.COLUMN, false, getResString("err.empty", this.getResString("columnType")));
			return false;
		}
		//栏目不能选择自己为父级
		if(column.getCategoryId() == column.getCategoryCategoryId()){
			this.outJson( response, net.mingsoft.basic.constant.ModelCode.COLUMN, false, getResString("err.same", this.getResString("columnCategoryIdCompared")));
			return false;
		}
		return true;
	}

	
	
	/**
	 * @param column 栏目表实体
	 * <i>column参数包含字段信息参考：</i><br/>
	 * columnCategoryid:多个columnCategoryid直接用逗号隔开,例如columnCategoryid=1,2,3,4
	 * 批量删除栏目表
	 *            <dt><span class="strong">返回</span></dt><br/>
	 *            <dd>{code:"错误编码",<br/>
	 *            result:"true｜false",<br/>
	 *            resultMsg:"错误信息"<br/>
	 *            }</dd>
	 */
	@ApiOperation(value = "批量删除栏目表")
	@ApiImplicitParam(name = "ids", value = "栏目编号", required = true,paramType="query")
	@PostMapping("/delete")
	@ResponseBody
	public void delete(HttpServletResponse response, HttpServletRequest request) {
		int[] ids = BasicUtil.getInts("ids", ",");
		for(int i=0;i<ids.length;i++){
			if(columnBiz.getEntity(ids[i]) != null){
			    columnBiz.deleteCategory(ids[i]);
			}
		}
		this.outJson(response, true);
	}
		
	/**
	 * 栏目更新页面跳转
	 * @param columnId 栏目ID
	 * @param request
	 * @param model
	 * @return 编辑栏目页
	 */
	@ApiOperation(value = "栏目更新页面跳转")
	@ApiImplicitParam(name = "columnId", value = "栏目ID", required = true,paramType="path")
	@GetMapping("/{columnId}/edit")
	public String edit(@PathVariable @ApiIgnore int columnId, HttpServletRequest request,@ApiIgnore ModelMap model) {
		// 获取管理实体
		// 站点ID
		int appId = BasicUtil.getAppId();
		List<ColumnEntity> list = new ArrayList<ColumnEntity>();
		// 判断管理员权限,查询其管理的栏目集合
		list = columnBiz.queryAll(appId, this.getModelCodeId(request));
		//查询当前栏目实体
		ColumnEntity column = (ColumnEntity) columnBiz.getEntity(columnId);
		model.addAttribute("appId",appId);
		model.addAttribute("column", column);
		model.addAttribute("columnc", column.getCategoryId());
		ColumnEntity columnSuper = new ColumnEntity();
		// 获取父栏目对象
		if (column.getCategoryCategoryId() != Const.COLUMN_TOP_CATEGORY_ID) {
			columnSuper = (ColumnEntity) columnBiz.getEntity(column.getCategoryCategoryId());
		}
		model.addAttribute("columnSuper", columnSuper);
		model.addAttribute("listColumn", JSONArray.toJSONString(list));
		return "/basic/column/form";
	}
	
	/**
	 * 栏目首页面列表显示
	 */
	@ApiOperation(value = "栏目首页面列表显示")
	@SuppressWarnings("deprecation")
	@GetMapping("/list")
	public void list(@ModelAttribute @ApiIgnore ColumnEntity column,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model) {

		// 站点ID有session获取
		int websiteId = BasicUtil.getAppId();
		// 需要打开的栏目节点树的栏目ID
		List list = columnBiz.queryAll(websiteId, this.getModelCodeId(request));
		EUListBean _list = new EUListBean(list, list.size());
		this.outJson(response, net.mingsoft.base.util.JSONArray.toJSONString(_list));
	}
	
	/**
	 * 栏目添加
	 * 
	 * @param column
	 *            栏目对象
	 * @return 返回页面跳转
	 */
	@ApiOperation(value = "栏目添加")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryTitle", value = "栏目标题", required = true,paramType="query"),
		@ApiImplicitParam(name = "columnType", value = "栏目属性 1，COLUMN_TYPE_LIST 代表最终栏目列表 2， COLUMN_TYPE_COVER代表频道封面", required = true,paramType="query"),
		@ApiImplicitParam(name = "columnKeyword", value = "栏目简介", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnDescrip", value = "栏目关键字的扩展", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnUrl", value = "如果为最终栏目列表，则保持栏目列表的地址,如果为外部链接，则保存外部链接的地址", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnListUrl", value = "最终列表栏目的列表模板地址", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnContentModelId", value = "栏目类型，直接影响栏目发布的表单样式", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnPath", value = "栏目保存路径", required = false,paramType="query"),
	})
	@PostMapping("/save")
	public void save(@ModelAttribute @ApiIgnore ColumnEntity column,HttpServletRequest request,HttpServletResponse response) {
		if(!checkForm(column,response)){
			return;
		}
		columnBiz.save(column, this.getModelCodeId(request), this.getManagerId(request));
		this.outJson(response, ModelCode.COLUMN, true,null,JSONArray.toJSONString(column.getCategoryId()));
	}
	
	/**
	 * 更新栏目
	 * @param column 栏目实体
	 * @param request
	 * @param response
	 */
	@ApiOperation(value = "更新栏目")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryId", value = "类别的编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnKeyword", value = "栏目简介", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnDescrip", value = "栏目关键字的扩展", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnType", value = "栏目属性", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnUrl", value = "如果为最终栏目列表，则保持栏目列表的地址,如果为外部链接，则保存外部链接的地址", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnListUrl", value = "最终列表栏目的列表模板地址", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnContentModelId", value = "栏目类型，直接影响栏目发布的表单样式", required = false,paramType="query"),
		@ApiImplicitParam(name = "columnPath", value = "栏目保存路径", required = false,paramType="query"),
		@ApiImplicitParam(name = "categorySmallImg", value = "缩略图", required = false,paramType="query"),
	})
	@PostMapping("/update")
	@ResponseBody
	public void update(@ModelAttribute @ApiIgnore ColumnEntity column,HttpServletRequest request,HttpServletResponse response) {
		ColumnEntity _column = (ColumnEntity) columnBiz.getEntity(column.getCategoryId());
		String categorySmallImg =column.getCategorySmallImg();
		String _categorySmallImg = _column.getCategorySmallImg();
		//删除缩略图时同时删除图片文件
		if(!StringUtil.isBlank(_categorySmallImg) ){
			if(!_categorySmallImg.equals(categorySmallImg) || StringUtil.isBlank(categorySmallImg)){
			//原始路径是以"/"拼接，将原始路径转化为windows正常路径
			String categorySmallImgs = _categorySmallImg.replace("/", File.separator);
			//获取项目tomcat路径
			String path = BasicUtil.getRealPath(categorySmallImgs);
			FileUtil.del(path);
		}
	}
		columnBiz.update(column, this.getModelCodeId(request), this.getManagerId(request));
		this.outJson(response, ModelCode.COLUMN, true,null,JSONArray.toJSONString(column.getCategoryId()));
	}
}
