/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.biz.ICategoryBiz;
import net.mingsoft.basic.dao.ICategoryDao;
import net.mingsoft.basic.entity.CategoryEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="categoryBiz")
public class CategoryBizImpl
extends BaseBizImpl
implements ICategoryBiz {
    private ICategoryDao categoryDao;

    @Override
    public int count(CategoryEntity category) {
        return this.categoryDao.count(category);
    }

    @Override
    public void deleteCategory(int categoryId) {
        CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(categoryId);
        if (category != null) {
            category.setCategoryParentId(null);
            List<CategoryEntity> childrenList = this.categoryDao.queryChildren(category);
            int[] ids = new int[childrenList.size()];
            for (int i = 0; i < childrenList.size(); ++i) {
                ids[i] = childrenList.get(i).getCategoryId();
            }
            this.categoryDao.delete(ids);
            this.categoryDao.deleteEntity(categoryId);
            this.deleteEntity(categoryId);
        }
    }

    public ICategoryDao getCategoryDao() {
        return this.categoryDao;
    }

    protected IBaseDao getDao() {
        return this.categoryDao;
    }

    public BaseEntity getEntity(BaseEntity entity) {
        CategoryEntity category = (CategoryEntity)((Object)super.getEntity(entity));
        if (category == null) {
            return null;
        }
        List childs = this.categoryDao.query(category);
        this.resetChildren(category, childs);
        return category;
    }

    public BaseEntity getEntity(int id) {
        CategoryEntity category = (CategoryEntity)super.getEntity(id);
        if (category != null) {
            List<CategoryEntity> childs = this.categoryDao.queryChildren(category);
            this.resetChildren(category, childs);
        }
        return category;
    }

    public List query(BaseEntity entity) {
        List list = super.query(entity);
        ArrayList<CategoryEntity> childList = new ArrayList<CategoryEntity>();
        childList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            CategoryEntity c = (CategoryEntity)((Object)list.get(i));
            this.resetChildren(c, childList);
        }
        return list;
    }

    @Override
    public List<CategoryEntity> queryBatchCategoryById(List<Integer> listId) {
        return this.categoryDao.queryBatchCategoryById(listId);
    }

    @Override
    public List<CategoryEntity> queryByAppIdOrModelId(Integer appId, Integer modelId) {
        return this.categoryDao.queryByAppIdOrModelId(appId, modelId);
    }

    @Override
    public List queryByDictId(CategoryEntity category) {
        return this.categoryDao.queryByDictId(category);
    }

    @Override
    public List<CategoryEntity> queryChildrenCategory(int categoryId, int appId, int modelId) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryAppId(appId);
        category.setCategoryModelId(modelId);
        category.setCategoryId(categoryId);
        return this.categoryDao.queryChildren(category);
    }

    @Override
    public synchronized int[] queryChildrenCategoryIds(int categoryId, int appId, int modelId) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryAppId(appId);
        category.setCategoryModelId(modelId);
        category.setCategoryId(categoryId);
        List<CategoryEntity> list = this.categoryDao.queryChildren(category);
        int[] ids = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CategoryEntity _category = list.get(i);
            ids[i] = _category.getCategoryId();
        }
        return ids;
    }

    @Override
    public List<CategoryEntity> queryChilds(CategoryEntity category) {
        return this.categoryDao.queryChilds(category);
    }

    private void resetChildren(CategoryEntity category, List<CategoryEntity> chrildrenCategoryList) {
        for (CategoryEntity c : chrildrenCategoryList) {
            if (c.getCategoryCategoryId() != category.getCategoryId() || category.getChildrenCategoryList().contains((Object)c)) continue;
            category.getChildrenCategoryList().add(c);
            this.resetChildren(c, chrildrenCategoryList);
        }
    }

    @Override
    public int saveCategory(CategoryEntity categoryEntity) {
        if (categoryEntity.getCategoryCategoryId() > 0) {
            CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(categoryEntity.getCategoryCategoryId());
            if (StringUtils.isEmpty((CharSequence)category.getCategoryParentId())) {
                categoryEntity.setCategoryParentId(categoryEntity.getCategoryCategoryId() + "");
            } else {
                categoryEntity.setCategoryParentId(category.getCategoryParentId() + "," + categoryEntity.getCategoryCategoryId());
            }
        }
        this.categoryDao.saveEntity(categoryEntity);
        return this.saveEntity(categoryEntity);
    }

    @Autowired
    public void setCategoryDao(ICategoryDao categoryDao) {
        this.categoryDao = categoryDao;
    }

    @Override
    public void updateCategory(CategoryEntity categoryEntity) {
        if (categoryEntity.getCategoryCategoryId() > 0) {
            CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(categoryEntity.getCategoryCategoryId());
            if (StringUtils.isEmpty((CharSequence)category.getCategoryParentId())) {
                categoryEntity.setCategoryParentId(categoryEntity.getCategoryCategoryId() + "");
            } else {
                categoryEntity.setCategoryParentId(category.getCategoryParentId() + "," + categoryEntity.getCategoryCategoryId());
            }
        }
        this.categoryDao.updateEntity(categoryEntity);
        this.updateEntity(categoryEntity);
    }
}

