package net.mingsoft.basic.action.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mingsoft.ueditor.MsUeditorActionEnter;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 百度编辑器上传
 * @author 铭飞开源团队
 * @date 2019年7月16日
 */
@Controller("ueAction")
@RequestMapping("/static/plugins/ueditor/{version}/jsp")
public class EditorAction {

    /**
     * 上传路径
     */
    @Value("${ms.upload.path}")
    private String uploadFloderPath;

    /**
     * 上传路径映射
     */
    @Value("${ms.upload.mapping}")
    private String uploadMapping;
    @ResponseBody
    @RequestMapping("editor")
    public String editor(HttpServletRequest request, HttpServletResponse response, String jsonConfig){
        String rootPath = BasicUtil.getRealPath("");
//        //如果是绝对路径就直接使用配置的绝对路径
//        if (uploadFloderPath.startsWith("file:")) {
//            rootPath = uploadFloderPath.substring(5);
//            //因为绝对路径已经映射了路径所以隐藏
//            jsonConfig = jsonConfig.replace("{ms.upload}", "");
//        } else {
//            //如果是相对路径替换成配置的路径
//            jsonConfig = jsonConfig.replace("{ms.upload}", uploadFloderPath);
//        }
        jsonConfig = jsonConfig.replace("{ms.upload}", uploadFloderPath);
//        //执行exec()方法才保存文件
        String json = new MsUeditorActionEnter(request, rootPath, jsonConfig).exec();
//        if (uploadFloderPath.startsWith("file:")) {
//            //如果是配置的绝对路径需要在前缀加上映射路径
//            Map data = (Map) JSON.parse(json);
//            data.put("url", uploadMapping.replace("/**", "") + data.get("url"));
//            return JSON.toJSONString(data);
//        }
        return json;
    }
}
