/**
The MIT License (MIT) * Copyright (c) 2016 铭飞科技(mingsoft.net)

 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package net.mingsoft.basic.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.basic.biz.IBasicBiz;
import net.mingsoft.basic.biz.ICategoryBiz;
import net.mingsoft.basic.entity.BasicEntity;
import net.mingsoft.basic.entity.CategoryEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.ModelEntity;

import net.mingsoft.basic.util.StringUtil;
import springfox.documentation.annotations.ApiIgnore;


/**
 * 基础应用层
 * @author 铭飞开发团队
 * @version 
 * 版本号：100-000-000<br/>
 * 创建日期：2014-6-15<br/>
 * 历史修订：<br/>
 */
@Api("基础应用层")
@Controller
@RequestMapping("/${ms.manager.path}/basic")
public class BasicAction extends BaseAction {

	/**
	 * 业务层的注入
	 */
	@Autowired
	private IBasicBiz basicBiz;
	
	/**
	 * 业务层的注入
	 */
	@Autowired
	private ICategoryBiz categoryBiz;

	/**
	 * 加载页面显示所有文章信息
	 * @param request 请求对象
	 * @param mode ModelMap实体对象
	 * @param response 响应对象
	 * @return 返回文章页面显示地址
	 */
	@ApiOperation(value = "加载页面显示所有文章信息")
	@ApiImplicitParam(name = "modelCode", value = "模块编码", required = true,paramType="query")
	@SuppressWarnings("static-access")
	@GetMapping("/index")
	public String index(HttpServletRequest request,@ApiIgnore ModelMap mode, HttpServletResponse response) {
		
		// 获取站点id
		int appId = ((ManagerSessionEntity) this.getManagerBySession(request)).getBasicId();
		ModelEntity model = this.getCategoryModelCode(request);
		if (model==null) {
			this.outString(response, this.getResString("err"));
			return null;
		}
		List<CategoryEntity> list = categoryBiz.queryByAppIdOrModelId(appId,model.getModelId() );
		JSONObject ja = new JSONObject();
		request.setAttribute("listCategory", ja.toJSON(list).toString());
		// 返回路径
		return "/basic/index"; 
	}
	
	/**
	 * 加载文章列表页面，显示列表信息
	 * @param request 请求对象
	 * @param categoryId 栏目id
	 * @return 文章列表页面
	 */
	@ApiOperation(value = "加载文章列表页面，显示列表信息")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryId", value = "栏目id", required = true,paramType="path"),
		@ApiImplicitParam(name = "pageNo", value = "页数", required = false,paramType="query"),
	})
	@GetMapping("/{categoryId}/list")
	public String list(HttpServletRequest request,@PathVariable @ApiIgnore int categoryId) {
		String keyWord = request.getParameter("keyword");
		String categoryTitle = request.getParameter("categoryTitle");		
		// 当前页面
		int pageNo = 1;
		// 获取页面的当页数
		if (request.getParameter("pageNo") != null) {
			pageNo = Integer.parseInt(request.getParameter("pageNo"));
		}
		int count = 0;
		request.setAttribute("basicList", null);
		request.setAttribute("categoryId", categoryId);
		return "/basic/basic_list";
	}

	/**
	 * 加载添加文章页面
	 * @param request 请求对象
	 * @param response 响应对象
	 * @return 添加页面地址
	 */
	@ApiOperation(value = "加载添加文章页面")
	@ApiImplicitParam(name = "categoryId", value = "栏目id", required = true,paramType="query")
	@GetMapping("/add")
	public String add(HttpServletRequest request, HttpServletResponse response) {
		String categoryId = request.getParameter("categoryId");		
		request.setAttribute("categoryId", categoryId);
		return "/basic/basic";
	}

	/**
	 * 保存文章实体
	 * @param basic 文章实体对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@ApiOperation(value = "保存文章实体")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "basicModelId", value = "模块编号", required = true,paramType="query"),
		@ApiImplicitParam(name = "basicAppId", value = "文章所属应用", required = true,paramType="query"),
		@ApiImplicitParam(name = "basicTitle", value = "标题 长度:200", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicDescription", value = "描述 长度:1500", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicThumbnails", value = "缩略图 长度:200", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicHit", value = "点击次数", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicCategoryId", value = "所属分类编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicPeopleId", value = "用户编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicDateTime", value = "发布时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicUpdateTime", value = "更新时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicSort", value = "排序", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicType", value = "通用属性", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicDisplay", value = "显示属性", required = false,paramType="query")
	})
	@PostMapping("/save")
	public void save(@ModelAttribute @ApiIgnore BasicEntity basic, HttpServletRequest request, HttpServletResponse response) {
		basic.setBasicAppId(this.getAppId(request));
		basic.setBasicModelId(this.getModelCodeId(request));
		basicBiz.saveEntity(basic);
		this.outJson(response, null, true);
	}

	/**
	 * 加载编辑文档页面
	 * @param basicId 文章id
	 * @param request 请求对象
	 * @return 编辑文档页面
	 */
	@ApiOperation(value = "加载编辑文档页面")
	@ApiImplicitParam(name = "basicId", value = "文章id", required = true,paramType="path")
	@GetMapping("/{basicId}/edit")
	public String edit(@PathVariable @ApiIgnore int basicId, HttpServletRequest request) {
		BasicEntity basic = basicBiz.getBasic(basicId);
		request.setAttribute("basic", basic);
		return "/basic/basic";
	}

	/**
	 * 修改文章实体
	 * @param basic 文章实体
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@ApiOperation(value = "修改文章实体")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "basicId", value = "文章编号", required = true,paramType="query"),
		@ApiImplicitParam(name = "basicTitle", value = "标题 长度:200", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicDescription", value = "描述 长度:1500", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicThumbnails", value = "缩略图 长度:200", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicHit", value = "点击次数", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicCategoryId", value = "所属分类编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicPeopleId", value = "用户编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicDateTime", value = "发布时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicUpdateTime", value = "更新时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicAppId", value = "文章所属应用", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicSort", value = "排序", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicType", value = "通用属性", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicModelId", value = "模块编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "basicDisplay", value = "显示属性", required = false,paramType="query")
	})
	@PostMapping("/update")
	@ResponseBody
	public void update(@ModelAttribute @ApiIgnore BasicEntity basic, HttpServletRequest request, HttpServletResponse response) {
		basicBiz.updateBasic(basic);
		this.outJson(response, null, true);
	}
	
	/**
	 * 根据文章id删除文章实体
	 * @param basicId 文章id
	 * @param response 响应对象
	 * @param request 请求对象
	 */
	@ApiOperation(value = "根据文章id删除文章实体")
	@ApiImplicitParam(name = "basicId", value = "文章id", required = true,paramType="path")
	@PostMapping("/{basicId}/delete")
	@ResponseBody
	public void delete(@PathVariable @ApiIgnore int basicId, HttpServletResponse response, HttpServletRequest request) {
		basicBiz.deleteBasic(basicId);
		this.outJson(response, null, true);
	}
	
	/**
	 * 文章多选删除方法
	 * @param response 响应对象
	 * @param request 请求对象
	 */
	@ApiOperation(value = "文章多选删除方法")
	@ApiImplicitParam(name = "basicIds", value = "文章id,多个用逗号隔开", required = true,paramType="path")
	@PostMapping("/allDelete")
	@ResponseBody
	public void allDelete(HttpServletResponse response, HttpServletRequest request) {
		String basicIds = request.getParameter("basicIds");
		if (!StringUtil.isBlank(basicIds)) {
			for (int i = 0; i < basicIds.split(",").length; i++) {
				int basicId = Integer.parseInt(basicIds.split(",")[i]);
				// 获取id，查询该文章是否在该站点下
				basicBiz.deleteBasic(basicId);
			}
		}
		this.outJson(response, null, true);
	}
	
	/**
	 * 获取列表提供给ajax使用
	 * @param response 响应对象
	 * @param request 请求对象
	 */
	@ApiOperation(value = "获取列表提供给ajax使用")
	@GetMapping("/listForAjax")
	public void listForAjax( HttpServletResponse response, HttpServletRequest request) {
	}
	
	/**
	 * 获取所有json数据
	 */
	/**
	 * 查询栏目下所有文章
	 * @param categoryId 栏目id
	 * @param request 请求对象
	 * @param mode ModelMap实体对象
	 * @param response 响应对象
	 */
	@ApiOperation(value ="获取所有json数据")
	@ApiImplicitParam(name = "categoryId", value = "栏目id", required = true,paramType="path")
	@GetMapping("/{categoryId}/query")
	public void query( @PathVariable @ApiIgnore Integer categoryId,HttpServletRequest request,@ApiIgnore ModelMap mode, HttpServletResponse response) {
		List<BasicEntity> list = basicBiz.query(categoryId);
		String jsonStr = JSONObject.toJSONString(list);
		LOG.debug(jsonStr);
		this.outJson(response, jsonStr);
	}
	
	
}