/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.ZipUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.ModelCode;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u83b7\u53d6\u6709\u5173\u6a21\u7248\u6587\u4ef6\u5939\u6216\u6a21\u7248\u6587\u4ef6\u4fe1\u606f")
@Controller(value="/basicTemplate")
@RequestMapping(value={"/${ms.manager.path}/template"})
public class TemplateAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;
    private static String TEMPLATE = "templets";
    private static String MOBILE = "m";

    @ApiOperation(value="\u67e5\u8be2\u6a21\u7248\u98ce\u683c\u4f9b\u7ad9\u70b9\u9009\u62e9")
    @GetMapping(value={"/queryAppTemplateSkin"})
    @ResponseBody
    public Map queryAppTemplateSkin(HttpServletRequest request) {
        List<String> folderNameList = this.queryTemplateFile(request);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (folderNameList != null) {
            map.put("fileName", folderNameList);
        }
        return map;
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u7248\u6587\u4ef6\u4f9b\u680f\u76ee\u9009\u62e9")
    @GetMapping(value={"/queryTemplateFileForColumn"})
    @ResponseBody
    public List<String> queryTemplateFileForColumn(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String path = BasicUtil.getRealPath(TEMPLATE) + File.separator + managerSession.getBasicId();
        int websiteId = managerSession.getBasicId();
        AppEntity website = (AppEntity)this.appBiz.getEntity(websiteId);
        path = path + File.separator + website.getAppStyle();
        this.LOG.debug("tempPath:" + path);
        ArrayList<String> listName = new ArrayList<String>();
        this.files(listName, new File(path), website.getAppStyle());
        return listName;
    }

    private void files(List list, File fileDir, String style) {
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File currFile = files[i];
                if (currFile.isFile()) {
                    String ex = currFile.getName();
                    if (!ex.endsWith("htm") && !ex.endsWith("html")) continue;
                    String _pathName = new String();
                    _pathName = this.files(currFile, style, _pathName);
                    list.add(_pathName + currFile.getName());
                    continue;
                }
                if (!currFile.isDirectory() || currFile.getName().equalsIgnoreCase(MOBILE)) continue;
                this.files(list, currFile, style);
            }
        }
    }

    private String files(File file, String style, String pathName) {
        if (!file.getParentFile().getName().equals(style)) {
            pathName = file.getParentFile().getName() + "/" + pathName;
            pathName = this.files(file.getParentFile(), style, pathName);
        }
        return pathName;
    }

    @ApiOperation(value="\u70b9\u51fb\u6a21\u7248\u7ba1\u7406\uff0c\u83b7\u53d6\u6240\u6709\u7684\u6a21\u7248\u6587\u4ef6\u540d")
    @ApiImplicitParam(name="pageNo", value="pageNo", required=true, paramType="query")
    @GetMapping(value={"/queryTemplateSkin"})
    protected String queryTemplateSkin(HttpServletResponse response, @ApiIgnore ModelMap model, HttpServletRequest request) {
        String pageNo = request.getParameter("pageNo");
        if (!NumberUtils.isNumber((String)pageNo)) {
            pageNo = "1";
        }
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List<String> folderNameList = this.queryTemplateFile(request);
        model.addAttribute("folderNameList", folderNameList);
        model.addAttribute("websiteId", (Object)managerSession.getBasicId());
        int recordCount = 0;
        if (folderNameList != null) {
            recordCount = folderNameList.size();
        }
        BasicUtil.setCookie(response, CookieConstEnum.PAGENO_COOKIE, pageNo);
        return "/basic/template/template_list";
    }

    @ApiOperation(value="\u89e3\u538bzip\u6a21\u7248\u6587\u4ef6")
    @ApiImplicitParam(name="fileUrl", value="\u6587\u4ef6\u8def\u5f84", required=true, paramType="query")
    @GetMapping(value={"/unZip"})
    @ResponseBody
    @RequiresPermissions(value={"template:upload"})
    public String unZip(@ApiIgnore ModelMap model, HttpServletRequest request) throws IOException {
        boolean hasDic = false;
        String entryName = "";
        String fileUrl = request.getParameter("fileUrl");
        File file = new File(BasicUtil.getRealPath(fileUrl));
        ZipUtil.unzip((File)file, (File)new File(BasicUtil.getRealPath(fileUrl.substring(0, fileUrl.length() - file.getName().length()))));
        FileUtils.forceDelete((File)file);
        return entryName;
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u7248")
    @ApiImplicitParam(name="fileName", value="\u6a21\u7248\u540d\u79f0", required=true, paramType="query")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"template:del"})
    public boolean delete(HttpServletRequest request) {
        String fileName = request.getParameter("fileName");
        String path = BasicUtil.getRealPath(TEMPLATE + File.separator + BasicUtil.getAppId() + File.separator + fileName);
        try {
            FileUtils.deleteQuietly((File)new File(path));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getTemplateUrl(HttpServletRequest request, String fileNameUrl) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String templetsUrl = BasicUtil.getRealPath(TEMPLATE + File.separator + managerSession.getBasicId() + File.separator + fileNameUrl);
        return templetsUrl;
    }

    @ApiOperation(value="\u663e\u793a\u5b50\u6587\u4ef6\u548c\u5b50\u6587\u4ef6\u5939")
    @ApiImplicitParam(name="skinFolderName", value="skinFolderName", required=true, paramType="query")
    @GetMapping(value={"/showChildFileAndFolder"})
    public String showChildFileAndFolder(HttpServletResponse response, @ApiIgnore ModelMap model, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        ArrayList<String> folderNameList = null;
        String skinFolderName = request.getParameter("skinFolderName");
        File[] files = new File(BasicUtil.getRealPath(skinFolderName)).listFiles();
        if (files != null) {
            folderNameList = new ArrayList<String>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                File currFile = files[i];
                String filter = BasicUtil.getRealPath(TEMPLATE + File.separator + BasicUtil.getAppId());
                this.LOG.debug("\u8fc7\u6ee4\u8def\u5f84" + filter);
                String temp = currFile.getPath();
                temp = temp.replace(File.separator.equals("\\") ? "/" : "\\", File.separator.equals("/") ? "\\" : "/").replace(filter, "");
                if (currFile.isDirectory()) {
                    folderNameList.add(temp);
                    continue;
                }
                fileNameList.add(temp);
            }
            folderNameList.addAll(fileNameList);
            model.addAttribute("fileNameList", folderNameList);
        }
        String uploadFileUrl = skinFolderName;
        model.addAttribute("uploadFileUrl", (Object)uploadFileUrl);
        model.addAttribute("websiteId", (Object)managerSession.getBasicId());
        return "/basic/template/template_file_list";
    }

    @ApiOperation(value="\u8bfb\u53d6\u6a21\u7248\u6587\u4ef6\u5185\u5bb9")
    @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query")
    @GetMapping(value={"/readFileContent"})
    @RequiresPermissions(value={"template:update"})
    public String readFileContent(@ApiIgnore ModelMap model, HttpServletRequest request) {
        String fileName = request.getParameter("fileName");
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            model.addAttribute("fileContent", (Object)FileReader.create((File)new File(BasicUtil.getRealPath(fileName))).readString());
        }
        model.addAttribute("name", (Object)new File(BasicUtil.getRealPath(fileName)).getName());
        model.addAttribute("fileName", (Object)fileName);
        model.addAttribute("fileNamePrefix", (Object)fileName.substring(0, fileName.lastIndexOf(File.separator) + 1));
        return "/basic/template/template_edit_file";
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u7248\u6587\u4ef6")
    @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query")
    @PostMapping(value={"/deleteTemplateFile"})
    @ResponseBody
    public int deleteTemplateFile(HttpServletRequest request) {
        int pageNo = 1;
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String fileName = request.getParameter("fileName");
        FileUtil.del((String)BasicUtil.getRealPath(TEMPLATE + File.separator + managerSession.getBasicId() + File.separator + fileName));
        this.getHistoryPageNoByCookie(request);
        return pageNo;
    }

    @ApiOperation(value="\u5199\u5165\u6a21\u7248\u6587\u4ef6\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="oldFileName", value="\u65e7\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="fileContent", value="\u6587\u4ef6\u5185\u5bb9", required=true, paramType="query")})
    @PostMapping(value={"/writeFileContent"})
    public void writeFileContent(@ApiIgnore ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = request.getParameter("fileName");
        String oldFileName = request.getParameter("oldFileName");
        String fileContent = request.getParameter("fileContent");
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            String templets = BasicUtil.getRealPath(fileName);
            this.LOG.debug(templets);
            FileWriter.create((File)new File(templets)).write(fileContent);
            if (!fileName.equals(oldFileName)) {
                File newName = new File(templets);
                File oldName = new File(BasicUtil.getRealPath(oldFileName));
                oldName.renameTo(newName);
                FileUtil.del((String)BasicUtil.getRealPath(oldFileName));
            }
            this.outJson(response, ModelCode.ROLE, true, null);
        }
    }

    private List<String> queryTemplateFile(HttpServletRequest request) {
        String templets;
        File file;
        String[] str;
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        ArrayList<String> folderNameList = null;
        if (!this.isSystemManager(request) && (str = (file = new File(templets = BasicUtil.getRealPath(TEMPLATE + File.separator + managerSession.getBasicId() + File.separator))).list()) != null) {
            folderNameList = new ArrayList<String>();
            for (int i = 0; i < str.length; ++i) {
                if (str[i].indexOf(".") >= 0) continue;
                folderNameList.add(str[i]);
            }
        }
        return folderNameList;
    }
}

