/**
The MIT License (MIT) * Copyright (c) 2016 铭飞科技(mingsoft.net)

 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package net.mingsoft.basic.action;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;

import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.constant.Const;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.ModelEntity;

import cn.hutool.crypto.SecureUtil;
import io.swagger.annotations.Api;
import net.mingsoft.base.constant.e.BaseEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;

/**
 * 基础应用层的父类base
 * 
 * @author 铭飞开发团队
 * @version 版本号：100-000-000<br/>
 *          创建日期：2015-7-19<br/>
 *          历史修订：<br/>
 */
@Api("基础应用层的父类base")
public abstract class BaseAction extends net.mingsoft.base.action.BaseAction {

	/**
	 * 根据当前的模块获取到当前模块的分类模块信息
	 * 
	 * @param request 请求对象
	 * @return 错误返回null，正确返回模块实体对象
	 */
	protected ModelEntity getCategoryModelCode(HttpServletRequest request) {
		Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
		if (NumberUtils.isNumber(obj.toString())) {
			net.mingsoft.basic.biz.IModelBiz modelBiz = (net.mingsoft.basic.biz.IModelBiz) SpringUtil
					.getBean(IModelBiz.class);
			return modelBiz.getModel(IModelBiz.CATEGORY_MODEL, Integer.parseInt(obj.toString()));
		} else {
			return null;
		}
	}

	/**
	 * 根据当前的模块获取到当前模块的basic文章模块信息
	 * 
	 * @param request 请求对象
	 * @return 错误返回null，正确返回模块实体对象
	 */
	protected ModelEntity getBasicModelCode(HttpServletRequest request) {
		Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
		if (NumberUtils.isNumber(obj.toString())) {
			net.mingsoft.basic.biz.IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
			return modelBiz.getModel(IModelBiz.BASIC_MODEL, Integer.parseInt(obj.toString()));
		} else {
			return null;
		}
	}

	/**
	 * 获取管理员id，规则：没有父ID就获取自身的ID
	 * 
	 * @param request 请求对象
	 * @return 管理员编号
	 */
	protected int getManagerId(HttpServletRequest request) {
		ManagerSessionEntity managerSession = (ManagerSessionEntity) this.getManagerBySession(request);
		int managerParent = managerSession.getManagerParentID();

		if (managerParent == 0) {
			return managerSession.getManagerId();
		} else {
			return managerParent;
		}
	}

	/**
	 * 判断当前管理员是否是系统平台管理员
	 * 
	 * @param request 请求对象
	 * @return true:是系统平台管理员，false:不是系统平台管理员
	 */
	protected boolean isSystemManager(HttpServletRequest request) {
		ManagerSessionEntity manager = (ManagerSessionEntity) getManagerBySession(request);
		if (manager.getManagerRoleID() == Const.DEFAULT_SYSTEM_MANGER_ROLE_ID) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 读取管理员session
	 * 
	 * @param request 请求对象
	 * @return 获取不到就返回null
	 */
	protected ManagerSessionEntity getManagerBySession(HttpServletRequest request) {
		// 传入用管理员请求，读取管理员的session || super,调用父类的protected属性的getSession方法
		ManagerSessionEntity managerSession = (ManagerSessionEntity) BasicUtil
				.getSession(SessionConstEnum.MANAGER_SESSION);
		if (managerSession != null) {
			// 返回管理员的所有信息
			return managerSession;
		}
		return null;
	}

	protected String getResString(String key) {
		// TODO Auto-generated method stub
		return net.mingsoft.basic.constant.Const.RESOURCES.getString(key);
	}

	/**
	 * 验证验证码
	 * 
	 * @param request HttpServletRequest对象
	 * @return 如果相同，返回true，否则返回false
	 */
	protected boolean checkRandCode(HttpServletRequest request) {
		return checkRandCode(request, SessionConstEnum.CODE_SESSION.toString());
	}

	/**
	 * AES解密字符串,key值为当前应用编号
	 * 
	 * @param request HttpServletRequest对象
	 * @param str     需要解密的字符串
	 * @return 返回解密后的字符串
	 */
	protected String decryptByAES(HttpServletRequest request, String str) {
		// 这里存在一个糊涂工具的bug必须先用变量保存变量再返回
		String _str = SecureUtil.aes(SecureUtil.md5(this.getApp(request).getAppId() + "").substring(16).getBytes())
				.decryptStr(str);
		return _str;
	}

	/**
	 * AES加密字符串,key值为当前应用编号
	 * 
	 * @param request HttpServletRequest对象
	 * @param str     需要加密的字符串
	 * @return 返回加密后的字符串
	 */
	protected String encryptByAES(HttpServletRequest request, String str) {
		// 这里存在一个糊涂工具的bug必须先用变量保存变量再返回
		String _str = SecureUtil.aes(SecureUtil.md5(this.getApp(request).getAppId() + "").substring(16).getBytes())
				.encryptHex(str);
		return _str;
	}

	/**
	 * 根据cookie获取历史页码
	 * 
	 * @param request HttpServletRequest对象
	 * @return 返回历史页码，没找到返回０
	 */
	protected int getHistoryPageNoByCookie(HttpServletRequest request) {
		if (Integer.valueOf(BasicUtil.getCookie(CookieConstEnum.PAGENO_COOKIE)) >= 1) {
			return Integer.valueOf(BasicUtil.getCookie(CookieConstEnum.PAGENO_COOKIE));
		}
		return 0;
	}

	/**
	 * 获取当前模块对应的appid , appid主要根据用户的请求地址获得 推荐使用
	 * 
	 * @see BasicUtil
	 * @param request HttpServletRequest对象
	 * @return 返回appId，找不到对应app,返回0
	 */
	@Deprecated
	protected int getAppId(HttpServletRequest request) {
		return this.getApp(request).getAppId();
	}

	/**
	 * 获取当前模块对应的appid , appid主要根据用户的请求地址获得 推荐使用
	 * 
	 * @see BasicUtil
	 * @param request HttpServletRequest对象
	 * @return 返回appId，找不到对应app,返回0
	 */
	@Deprecated
	protected AppEntity getApp(HttpServletRequest request) {
		AppEntity app = new AppEntity();
		// 获取用户所请求的域名地址
		IAppBiz appBiz = (IAppBiz) SpringUtil.getBean(IAppBiz.class);
		AppEntity website = appBiz.getByUrl(this.getDomain(request));
		if (website == null) {
			return null;
		}
		BeanUtils.copyProperties(website, app);
		return app;
	}

	/**
	 * 获取验证码
	 * 
	 * @param request HttpServletRequest对象
	 * @return 返回验证码，获取不到返回null
	 */
	protected String getRandCode(HttpServletRequest request) {
		return BasicUtil.getSession(SessionConstEnum.CODE_SESSION) + "";
	}

	/**
	 * 根据加密过的模块编码获得模块编号
	 * 
	 * @param request HttpServletRequest对象
	 * @param code    编码
	 * @return 返回模块编号，如果没有返回0
	 */
	protected int getModelCodeIdForAES(HttpServletRequest request, String code) {
		net.mingsoft.basic.biz.IModelBiz modelBiz = (net.mingsoft.basic.biz.IModelBiz) SpringUtil
				.getBean(IModelBiz.class);
		ModelEntity model = modelBiz.getEntityByModelCode(this.decryptByAES(request, code));

		if (model != null) {
			return model.getModelId();
		}
		return 0;
	}

	/**
	 * 获取当前模块编号
	 * 
	 * @param request HttpServletRequest对象
	 * @return 返回当前模块编号，没找到返回0
	 */
	@Deprecated
	protected int getModelCodeId(HttpServletRequest request) {
		Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
		if (obj != null) {
			return Integer.parseInt(obj.toString());
		}
		return 0;
	}

	/**
	 * 根据当前模块编码父模块编号
	 * 
	 * @param request HttpServletRequest对象
	 * @return 返回模块编号，如果没有返回0
	 */
	protected int getRootModelCodeId(HttpServletRequest request) {
		Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
		if (NumberUtils.isNumber(obj.toString())) {
			net.mingsoft.basic.biz.IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
			ModelEntity model = (ModelEntity) modelBiz.getEntity(Integer.parseInt(obj.toString()));
			return model.getModelModelId();
		} else {
			return 0;
		}
	}

	/**
	 * 根据模块编码获得模块编号
	 * 
	 * @param request HttpServletRequest对象
	 * @param code    编码
	 * @return 返回模块编号，如果没有返回0
	 */
	protected int getModelCodeId(HttpServletRequest request, BaseEnum code) {
		net.mingsoft.basic.biz.IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
		ModelEntity model = modelBiz.getEntityByModelCode(code);
		if (model != null) {
			return model.getModelId();
		}
		return 0;
	}

	/**
	 * 根据模块编码获得模块编号
	 * 
	 * @param request HttpServletRequest对象
	 * @param code    编码
	 * @return 返回模块编号，如果没有返回0
	 * @deprecated 推荐使用加密过的模块编码获取模块编号,如getModelCodeIdForAES
	 */
	protected int getModelCodeId(HttpServletRequest request, String code) {
		net.mingsoft.basic.biz.IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
		ModelEntity model = modelBiz.getEntityByModelCode(code);
		if (model != null) {
			return model.getModelId();
		}
		return 0;
	}

	/**
	 * 读取管理员session
	 * 
	 * @param request HttpServletRequest对象
	 * @return 返回管理员session，获取不到就返回null
	 */
	protected String getCodeBySession(HttpServletRequest request) {
		// 传入用管理员请求，读取管理员的session || super,调用父类的protected属性的getSession方法
		Object obj = BasicUtil.getSession(SessionConstEnum.CODE_SESSION);
		if (obj != null) {
			// 返回管理员的所有信息
			return (String) obj;
		}
		return null;
	}

	/**
	 * 返回重定向
	 * 
	 * @param request HttpServletRequest对象
	 * @param flag    true:提供给springMVC返回，false:只是获取地址
	 * @return 返回重定向后的地址
	 */
	protected String redirectBack(HttpServletRequest request, boolean flag) {
		if (flag) {
			return "redirect:" + BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
		} else {
			return BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
		}

	}

	/**
	 * 验证验证码
	 * 
	 * @param param   表单验证码参数名称
	 * @param request HttpServletRequest对象
	 * @return 如果相同，返回true，否则返回false
	 */
	protected boolean checkRandCode(HttpServletRequest request, String param) {
		String sessionCode = this.getRandCode(request);
		String requestCode = request.getParameter(param);
		LOG.debug("session_code:" + sessionCode + " requestCode:" + requestCode);
		if (sessionCode.equalsIgnoreCase(requestCode)) {
			return true;
		}
		return false;
	}

	/**
	 * 该方法已经没有一样，直接返回对应ftl文件名称即可 视图层路径，会根据配置文件中的后台管理页面进行拼接
	 * 
	 * @param path 页面路径
	 * @return 最终视图层路径
	 */
	@Deprecated
	protected String view(String path) {
		return Const.VIEW + path;
	}

	/**
	 * 移除url参数
	 * 
	 * @param request
	 * @param fitlers 需要移除的字段名称
	 */
	@Deprecated
	protected void removeUrlParams(HttpServletRequest request, String[] fitlers) {
		request.setAttribute(Const.PARAMS, BasicUtil.assemblyRequestUrlParams(fitlers));
	}

}