/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IColumnBiz;
import net.mingsoft.basic.constant.ModelCode;
import net.mingsoft.basic.entity.ColumnEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u901a\u7528\u680f\u76ee\u5206\u7c7b")
@Controller(value="basicColumnAction")
@RequestMapping(value={"/${ms.manager.path}/column"})
public class ColumnAction
extends BaseAction {
    @Autowired
    private IColumnBiz columnBiz;

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        return "/basic/column/index";
    }

    @ApiOperation(value="\u680f\u76ee\u6dfb\u52a0\u8df3\u8f6c\u9875\u9762")
    @GetMapping(value={"/add"})
    public String add(HttpServletRequest request, ModelMap model) {
        int appId = BasicUtil.getAppId();
        List<ColumnEntity> list = this.columnBiz.queryAll(appId, this.getModelCodeId(request));
        ColumnEntity columnSuper = new ColumnEntity();
        model.addAttribute("appId", (Object)appId);
        model.addAttribute("columnSuper", (Object)columnSuper);
        model.addAttribute("column", (Object)new ColumnEntity());
        model.addAttribute("listColumn", (Object)com.alibaba.fastjson.JSONArray.toJSONString(list));
        return "/basic/column/form";
    }

    protected boolean checkForm(ColumnEntity column, HttpServletResponse response) {
        if (StringUtil.isBlank(column.getCategoryTitle())) {
            this.outJson(response, ModelCode.COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("categoryTitle")}));
            return false;
        }
        if (!StringUtil.checkLength(column.getCategoryTitle(), 1, 31)) {
            this.outJson(response, ModelCode.COLUMN, false, this.getResString("err.length", new String[]{this.getResString("categoryTitle"), "1", "30"}));
            return false;
        }
        if (StringUtil.isBlank(column.getColumnType() + "")) {
            this.outJson(response, ModelCode.COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("columnType")}));
            return false;
        }
        if (column.getCategoryId() == column.getCategoryCategoryId()) {
            this.outJson(response, ModelCode.COLUMN, false, this.getResString("err.same", new String[]{this.getResString("columnCategoryIdCompared")}));
            return false;
        }
        return true;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u680f\u76ee\u8868")
    @ApiImplicitParam(name="ids", value="\u680f\u76ee\u7f16\u53f7", required=true, paramType="query")
    @PostMapping(value={"/delete"})
    @ResponseBody
    public void delete(HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts("ids", ",");
        for (int i = 0; i < ids.length; ++i) {
            if (this.columnBiz.getEntity(ids[i]) == null) continue;
            this.columnBiz.deleteCategory(ids[i]);
        }
        this.outJson(response, true);
    }

    @ApiOperation(value="\u680f\u76ee\u66f4\u65b0\u9875\u9762\u8df3\u8f6c")
    @ApiImplicitParam(name="columnId", value="\u680f\u76eeID", required=true, paramType="path")
    @GetMapping(value={"/{columnId}/edit"})
    public String edit(@PathVariable @ApiIgnore int columnId, HttpServletRequest request, @ApiIgnore ModelMap model) {
        int appId = BasicUtil.getAppId();
        List<Object> list = new ArrayList();
        list = this.columnBiz.queryAll(appId, this.getModelCodeId(request));
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        model.addAttribute("appId", (Object)appId);
        model.addAttribute("column", (Object)column);
        model.addAttribute("columnc", (Object)column.getCategoryId());
        ColumnEntity columnSuper = new ColumnEntity();
        if (column.getCategoryCategoryId() != 0) {
            columnSuper = (ColumnEntity)this.columnBiz.getEntity(column.getCategoryCategoryId());
        }
        model.addAttribute("columnSuper", (Object)columnSuper);
        model.addAttribute("listColumn", (Object)com.alibaba.fastjson.JSONArray.toJSONString(list));
        return "/basic/column/form";
    }

    @ApiOperation(value="\u680f\u76ee\u9996\u9875\u9762\u5217\u8868\u663e\u793a")
    @GetMapping(value={"/list"})
    public void list(@ModelAttribute @ApiIgnore ColumnEntity column, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        int websiteId = BasicUtil.getAppId();
        List<ColumnEntity> list = this.columnBiz.queryAll(websiteId, this.getModelCodeId(request));
        EUListBean _list = new EUListBean(list, list.size());
        this.outJson(response, JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }

    @ApiOperation(value="\u680f\u76ee\u6dfb\u52a0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="columnType", value="\u680f\u76ee\u5c5e\u6027 1\uff0cCOLUMN_TYPE_LIST \u4ee3\u8868\u6700\u7ec8\u680f\u76ee\u5217\u8868 2\uff0c COLUMN_TYPE_COVER\u4ee3\u8868\u9891\u9053\u5c01\u9762", required=true, paramType="query"), @ApiImplicitParam(name="columnKeyword", value="\u680f\u76ee\u7b80\u4ecb", required=false, paramType="query"), @ApiImplicitParam(name="columnDescrip", value="\u680f\u76ee\u5173\u952e\u5b57\u7684\u6269\u5c55", required=false, paramType="query"), @ApiImplicitParam(name="columnUrl", value="\u5982\u679c\u4e3a\u6700\u7ec8\u680f\u76ee\u5217\u8868\uff0c\u5219\u4fdd\u6301\u680f\u76ee\u5217\u8868\u7684\u5730\u5740,\u5982\u679c\u4e3a\u5916\u90e8\u94fe\u63a5\uff0c\u5219\u4fdd\u5b58\u5916\u90e8\u94fe\u63a5\u7684\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="columnListUrl", value="\u6700\u7ec8\u5217\u8868\u680f\u76ee\u7684\u5217\u8868\u6a21\u677f\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="columnContentModelId", value="\u680f\u76ee\u7c7b\u578b\uff0c\u76f4\u63a5\u5f71\u54cd\u680f\u76ee\u53d1\u5e03\u7684\u8868\u5355\u6837\u5f0f", required=false, paramType="query"), @ApiImplicitParam(name="columnPath", value="\u680f\u76ee\u4fdd\u5b58\u8def\u5f84", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    public void save(@ModelAttribute @ApiIgnore ColumnEntity column, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkForm(column, response)) {
            return;
        }
        this.columnBiz.save(column, this.getModelCodeId(request), this.getManagerId(request));
        this.outJson(response, ModelCode.COLUMN, true, null, com.alibaba.fastjson.JSONArray.toJSONString((Object)column.getCategoryId()));
    }

    @ApiOperation(value="\u66f4\u65b0\u680f\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u7c7b\u522b\u7684\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="columnKeyword", value="\u680f\u76ee\u7b80\u4ecb", required=false, paramType="query"), @ApiImplicitParam(name="columnDescrip", value="\u680f\u76ee\u5173\u952e\u5b57\u7684\u6269\u5c55", required=false, paramType="query"), @ApiImplicitParam(name="columnType", value="\u680f\u76ee\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="columnUrl", value="\u5982\u679c\u4e3a\u6700\u7ec8\u680f\u76ee\u5217\u8868\uff0c\u5219\u4fdd\u6301\u680f\u76ee\u5217\u8868\u7684\u5730\u5740,\u5982\u679c\u4e3a\u5916\u90e8\u94fe\u63a5\uff0c\u5219\u4fdd\u5b58\u5916\u90e8\u94fe\u63a5\u7684\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="columnListUrl", value="\u6700\u7ec8\u5217\u8868\u680f\u76ee\u7684\u5217\u8868\u6a21\u677f\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="columnContentModelId", value="\u680f\u76ee\u7c7b\u578b\uff0c\u76f4\u63a5\u5f71\u54cd\u680f\u76ee\u53d1\u5e03\u7684\u8868\u5355\u6837\u5f0f", required=false, paramType="query"), @ApiImplicitParam(name="columnPath", value="\u680f\u76ee\u4fdd\u5b58\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="categorySmallImg", value="\u7f29\u7565\u56fe", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore ColumnEntity column, HttpServletRequest request, HttpServletResponse response) {
        ColumnEntity _column = (ColumnEntity)this.columnBiz.getEntity(column.getCategoryId());
        String categorySmallImg = column.getCategorySmallImg();
        String _categorySmallImg = _column.getCategorySmallImg();
        if (!(StringUtil.isBlank(_categorySmallImg) || _categorySmallImg.equals(categorySmallImg) && !StringUtil.isBlank(categorySmallImg))) {
            String categorySmallImgs = _categorySmallImg.replace("/", File.separator);
            String path = BasicUtil.getRealPath(categorySmallImgs);
            FileUtil.del((String)path);
        }
        this.columnBiz.update(column, this.getModelCodeId(request), this.getManagerId(request));
        this.outJson(response, ModelCode.COLUMN, true, null, com.alibaba.fastjson.JSONArray.toJSONString((Object)column.getCategoryId()));
    }
}

