/**
 * 
 */
package net.mingsoft.basic.action.web;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IBasicBiz;
import net.mingsoft.basic.biz.IBasicLogBiz;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.constant.e.LogEnum;
import net.mingsoft.basic.entity.BasicEntity;
import net.mingsoft.basic.entity.BasicLogEntity;
import net.mingsoft.basic.util.BasicUtil;
import springfox.documentation.annotations.ApiIgnore;

/**
 * <p>
 * <b>铭飞科技</b>
 * </p>
 * <p>
 * Copyright: Copyright (c) 2014 - 2015
 * </p>
 * @author 铭飞开发团队
 *         <p>
 *         Comments:错误页面定义
 *         </p>
 *         <p>
 *         Create Date:2015-4-26
 *         </p>
 *         <p>
 *         Modification history:
 *         </p>
 */
@Api("文章解析器接口")
@Controller("webBasicAction")
@RequestMapping("/basic/")
public class BasicAction extends BaseAction {

	/**
	 * 文章解析器
	 */
	@Autowired
	private IBasicBiz basicBiz;

	@Autowired
	private IBasicLogBiz basicLogBiz;

	/**
	 * 更新文章点击数
	 * 
	 * @param basicId
	 *            文章编号
	 *            <dt><span class="strong">返回</span></dt><br/>
	 *            {code:"模块编码",<br/>
	 *            result:"true｜false",<br/>
	 *            resultMsg:"错误信息",<br/>
	 *            resultData:"成功会返回最新点击数"<br/>
	 *            }
	 */
	@ApiOperation(value = "更新文章点击数")
	@ApiImplicitParam(name = "basicId", value = "文章编号", required = true,paramType="path")
	@GetMapping(value = "/{basicId}/hit")
	@ResponseBody
	public void hit(@PathVariable @ApiIgnore int basicId, HttpServletRequest request, HttpServletResponse response) {
		if (basicId <= 0) {
			this.outString(response, "document.write(0)");
			return;
		}
		// 获取文章实体
		BasicEntity basic = (BasicEntity) basicBiz.getEntity(basicId);
		// 判断文章是否存在
		if (basic == null) {
			this.outString(response, "document.write(0)");
			return;
		}
		int appId = BasicUtil.getAppId();
		// 判断该文章是否是改应用下
		if (basic.getBasicAppId() != appId) {
			this.outString(response, "document.write(0)");
			return;
		}
		boolean isShow = BasicUtil.getBoolean("isShow");
		if (isShow) {
			this.outString(response, "document.write(" + basic.getBasicHit() + ")");
			return;
		}
		BasicLogEntity basicLog = new BasicLogEntity();
		basicLog.setBasicLogAppId(appId);
		basicLog.setBasicLogDatetime(new Date());
		basicLog.setBasicLogIp(BasicUtil.getIp());
		basicLog.setBasicLogBasicId(basicId);
		if (this.isMobileDevice(request)) {
			basicLog.setBasicLogIsMobile(LogEnum.MOBILE.toInt());
		}
		int isHit = basicLogBiz.count(basicLog);
		basicBiz.updateHit(basicId, basic.getBasicHit() + 1);
		basicLogBiz.saveEntity(basicLog);
		this.outString(response, "document.write(" + (basic.getBasicHit() + 1) + ")");

	}
}
