/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.biz.impl;

import com.mingsoft.base.biz.impl.BaseBizImpl;
import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.dao.ICategoryDao;
import com.mingsoft.basic.entity.CategoryEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="categoryBiz")
public class CategoryBizImpl
extends BaseBizImpl
implements ICategoryBiz {
    private ICategoryDao categoryDao;

    public ICategoryDao getCategoryDao() {
        return this.categoryDao;
    }

    @Autowired
    public void setCategoryDao(ICategoryDao categoryDao) {
        this.categoryDao = categoryDao;
    }

    protected IBaseDao getDao() {
        return this.categoryDao;
    }

    @Override
    public int saveCategory(CategoryEntity categoryEntity) {
        this.categoryDao.saveEntity(categoryEntity);
        return this.saveEntity(categoryEntity);
    }

    @Override
    public int saveCategoryEntity(CategoryEntity categoryEntity) {
        return this.categoryDao.saveEntity(categoryEntity);
    }

    @Override
    public void deleteCategory(int categoryId) {
        this.categoryDao.deleteEntity(categoryId);
        this.deleteEntity(categoryId);
    }

    @Override
    public void deleteCategoryEntity(int categoryId) {
        this.categoryDao.deleteEntity(categoryId);
    }

    @Override
    public void updateCategory(CategoryEntity categoryEntity) {
        this.categoryDao.updateEntity(categoryEntity);
        this.updateEntity(categoryEntity);
    }

    @Override
    public void updateCategoryEntity(CategoryEntity categoryEntity) {
        this.categoryDao.updateEntity(categoryEntity);
    }

    @Override
    public CategoryEntity getCategory(int categoryId) {
        return (CategoryEntity)this.categoryDao.getEntity(categoryId);
    }

    @Override
    public List queryByPageList(CategoryEntity category, PageUtil page, String orderBy, boolean order) {
        return this.categoryDao.queryByPageList(category, page, orderBy, order);
    }

    @Override
    public List<CategoryEntity> queryChilds(CategoryEntity category) {
        return this.categoryDao.queryChilds(category);
    }

    @Override
    public int count(CategoryEntity category) {
        return this.categoryDao.count(category);
    }

    @Override
    public List<CategoryEntity> queryByModelId(CategoryEntity category) {
        return this.categoryDao.queryByModelId(category);
    }

    @Override
    public List<Integer> queryCategoryIdByTitle(String categoryTitle, int categoryModelId) {
        return this.categoryDao.queryCategoryIdByTitle(categoryTitle, categoryModelId);
    }

    @Override
    public List<Integer> queryCategoryIdByCategoryTitle(String categorySchoolName, int schoolModelId, int facultyModelId) {
        return this.categoryDao.queryCategoryIdByCategoryTitle(categorySchoolName, schoolModelId, facultyModelId);
    }

    @Override
    public CategoryEntity saveByCategoryTitle(String categoryTitle, int categoryCategoryId, int categoryModelId) {
        CategoryEntity category = new CategoryEntity();
        int categoryId = 0;
        if (StringUtil.isBlank((String)categoryTitle)) {
            category.setCategoryId(categoryId);
            return category;
        }
        List<Integer> list = this.queryCategoryIdByTitle(categoryTitle, categoryModelId);
        if (list != null && list.size() > 0) {
            categoryId = list.get(list.size() - 1);
        }
        if (categoryId == 0) {
            category.setCategoryTitle(categoryTitle);
            category.setCategoryCategoryId(categoryCategoryId);
            category.setCategoryModelId(categoryModelId);
            this.saveCategoryEntity(category);
        } else {
            category.setCategoryId(categoryId);
        }
        return category;
    }

    @Override
    public List<CategoryEntity> queryBatchCategoryById(List<Integer> listId) {
        return this.categoryDao.queryBatchCategoryById(listId);
    }

    @Override
    public List<CategoryEntity> queryChildrenCategory(int categoryId, int appId, int modelId) {
        return this.categoryDao.queryChildrenCategoryId(categoryId, appId, modelId);
    }

    @Override
    public synchronized List<Integer> queryChildrenCategoryIds(int categoryId, int appId, int modelId) {
        List<CategoryEntity> list = this.categoryDao.queryChildrenCategoryId(categoryId, appId, modelId);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        while (i < list.size()) {
            CategoryEntity category = list.get(i);
            ids.add(category.getCategoryId());
            ++i;
        }
        return ids;
    }

    @Override
    public List<CategoryEntity> queryByAppIdOrModelId(Integer appId, Integer modelId) {
        return this.categoryDao.queryByAppIdOrModelId(appId, modelId);
    }

    @Override
    public List<CategoryEntity> queryParent(int appId, int modelId, Integer categoryId) {
        String ids = this.categoryDao.queryParentIds(categoryId);
        if (!StringUtil.isBlank((String)ids)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            String[] _ids = ids.split(",");
            int i = 0;
            while (i < _ids.length) {
                list.add(Integer.parseInt(_ids[i]));
                ++i;
            }
            return this.categoryDao.queryBatchCategoryById(list);
        }
        return null;
    }

    @Override
    public List<CategoryEntity> queryByDescription(int appId, int modelId, String categoryDescription) {
        if (StringUtil.isBlank((String)categoryDescription)) {
            return null;
        }
        return this.categoryDao.queryByDescription(appId, modelId, categoryDescription);
    }

    @Override
    public List<Integer> queryCategoryIdsByModelIdAndAppId(int appId, int modelId) {
        List<CategoryEntity> list = this.categoryDao.queryByAppIdOrModelId(appId, modelId);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        while (i < list.size()) {
            CategoryEntity category = list.get(i);
            ids.add(category.getCategoryId());
            ++i;
        }
        return ids;
    }
}

