/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.aop;

import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.util.AESUtil;
import com.mingsoft.util.StringUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class BaseAop {
    protected final Logger LOG = Logger.getLogger(this.getClass());

    protected final <T> T getType(JoinPoint jp, Class<T> clazz) {
        Object[] objs;
        Object[] objectArray = objs = jp.getArgs();
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj.getClass() == clazz) {
                return (T)obj;
            }
            ++n2;
        }
        return null;
    }

    protected String getCode(HttpServletRequest request) {
        return request.getParameter("mail_code");
    }

    protected String encryptByAES(int appId, String str) {
        if (StringUtil.isBlank((String)str)) {
            return "";
        }
        return AESUtil.encrypt((String)str, (String)StringUtil.Md5((String)String.valueOf(appId)).substring(16));
    }

    protected int getAppId(HttpServletRequest request) {
        AppEntity app = this.getApp(request);
        if (app != null) {
            return app.getAppId();
        }
        return 0;
    }

    protected AppEntity getApp(HttpServletRequest request) {
        IAppBiz websiteBiz = (IAppBiz)this.getBean(request.getServletContext(), "appBiz");
        AppEntity website = websiteBiz.getByUrl(this.getDomain(request));
        return website;
    }

    protected Object getBean(ServletContext sc, String beanName) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc).getBean(beanName);
    }

    protected String getDomain(HttpServletRequest request) {
        String path = request.getContextPath();
        String domain = request.getServerName();
        domain = request.getServerPort() == 80 ? String.valueOf(domain) + path : String.valueOf(domain) + ":" + request.getServerPort() + path;
        return domain;
    }

    protected Object getSession(HttpServletRequest request, BaseSessionEnum key) {
        return request.getSession().getAttribute(key.toString());
    }
}

