/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action.web;

import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IRoleBiz;
import com.mingsoft.basic.biz.ISystemSkinBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.RoleEntity;
import com.mingsoft.basic.entity.SystemSkinEntity;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/ms"})
public class LoginAction
extends BaseAction {
    public static final String ADMIN_LOGIN_PATH = "/ms/login.do";
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IAppBiz appBiz;
    @Autowired
    private ISystemSkinBiz systemSkinBiz;

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest request) {
        AppEntity app = this.getApp(request);
        if (app != null) {
            SystemSkinEntity sse = this.systemSkinBiz.getByManagerId(app.getAppManagerId());
            if (sse != null && !StringUtil.isBlank((String)sse.getSystemSkinLoginPage())) {
                return "redirect:/" + sse.getSystemSkinLoginPage();
            }
        } else {
            String defaultId;
            File file = new File(this.getRealPath(request, "WEB-INF/ms.install"));
            if (file.exists() && !StringUtil.isBlank((String)(defaultId = FileUtil.readFile((String)this.getRealPath(request, "WEB-INF/ms.install")).trim()))) {
                app = (AppEntity)this.appBiz.getEntity(Integer.parseInt(defaultId));
                app.setAppUrl(this.getUrl(request));
                this.appBiz.updateEntity(app);
                File managerFile = new File(request.getSession().getServletContext().getRealPath("/"));
                new File(String.valueOf(managerFile.getParent()) + File.separator + "/manager").delete();
                FileUtil.writeFile((String)defaultId, (String)this.getRealPath(request, "WEB-INF/ms.install.bak"), (String)"utf-8");
                file.delete();
            }
        }
        request.setAttribute("app", (Object)app);
        request.setAttribute("loginPath", (Object)request.getServletPath().subSequence(0, request.getServletPath().indexOf("/login")));
        return "/manager/login";
    }

    @RequestMapping(value={"/checkLogin"}, method={RequestMethod.POST})
    public void checkLogin(@ModelAttribute ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        AppEntity urlWebsite = null;
        urlWebsite = this.appBiz.getByUrl(this.getDomain(request));
        if (urlWebsite == null) {
            this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.not.exist", new String[]{this.getResString("app")}));
            return;
        }
        ManagerEntity _manager = this.managerBiz.queryManagerByManagerName(manager.getManagerName());
        if (_manager == null) {
            this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.nameEmpty"));
        } else if (StringUtil.Md5((String)manager.getManagerPassword()).equals(_manager.getManagerPassword())) {
            SystemSkinEntity systemSkin = this.systemSkinBiz.getByManagerId(_manager.getManagerId());
            ManagerSessionEntity managerSession = new ManagerSessionEntity();
            AppEntity website = new AppEntity();
            RoleEntity role = (RoleEntity)this.roleBiz.getEntity(_manager.getManagerRoleID());
            website = this.appBiz.getByManagerId(role.getRoleManagerId());
            if (website != null && urlWebsite != null && urlWebsite.getAppId() == website.getAppId() && _manager.getManagerRoleID() > 1) {
                List<BaseEntity> childManagerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
                managerSession.setBasicId(website.getAppId());
                managerSession.setManagerParentID(role.getRoleManagerId());
                managerSession.setManagerChildIDs(childManagerList);
                managerSession.setStyle(website.getAppStyle());
                this.setSession(request, SessionConstEnum.MANAGER_ESSION, (Object)managerSession);
            } else if (_manager.getManagerRoleID() != 1) {
                this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.not.exist", new String[]{this.getResString("manager")}));
            } else {
                this.setSession(request, SessionConstEnum.MANAGER_ESSION, (Object)managerSession);
            }
            BeanUtils.copyProperties((Object)((Object)_manager), (Object)((Object)managerSession));
            if (systemSkin != null) {
                managerSession.setSystemSkin(systemSkin);
            }
            Subject subject = SecurityUtils.getSubject();
            UsernamePasswordToken upt = new UsernamePasswordToken(managerSession.getManagerName(), managerSession.getManagerPassword());
            subject.login((AuthenticationToken)upt);
            this.outJson(response, ModelCode.ADMIN_LOGIN, true, null);
        } else {
            this.outJson(response, ModelCode.ADMIN_LOGIN, false, this.getResString("err.password"));
        }
    }
}

