/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action.web;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.entity.CategoryEntity;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="webCategory")
@RequestMapping(value={"/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @RequestMapping(value={"/{categoryId}/getParentCategory"})
    @ResponseBody
    public void getParentCategory(@PathVariable int categoryId, HttpServletRequest request, HttpServletResponse response) {
        CategoryEntity category = this.categoryBiz.getCategory(categoryId);
        if (category != null) {
            CategoryEntity paCategory = this.categoryBiz.getCategory(category.getCategoryCategoryId());
            if (paCategory == null) {
                this.outJson(response, JSONObject.toJSONString((Object)((Object)category)));
            }
            this.outJson(response, JSONObject.toJSONString((Object)((Object)paCategory)));
        }
    }

    @RequestMapping(value={"/queryProvince"})
    @ResponseBody
    public void queryProvince(HttpServletRequest request, HttpServletResponse response) {
        int appId = this.getAppId(request);
        List<CategoryEntity> listProvince = this.categoryBiz.queryByAppIdOrModelId(appId, this.getModelCodeId(request, ModelCode.CITY));
        this.outJson(response, JSONObject.toJSONStringWithDateFormat(listProvince, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
    }

    @RequestMapping(value={"/{categoryId}/queryChildren"})
    public void queryChildren(@PathVariable int categoryId, HttpServletRequest request, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category != null) {
            List<CategoryEntity> list = this.categoryBiz.queryChilds(category);
            this.outJson(response, JSONObject.toJSONStringWithDateFormat(list, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

