/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.util.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/manager/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;

    @RequestMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute ModelEntity model, HttpServletRequest request, HttpServletResponse response) {
        model.setModelId(this.getManagerId(request));
        model.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (!StringUtil.checkLength((String)model.getModelTitle(), (int)1, (int)20)) {
            this.outJson(response, this.getResString("err.length", new String[]{this.getResString("modelTitle"), "2", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)model.getModelCode(), (int)1, (int)20)) {
            this.outJson(response, this.getResString("err.length", new String[]{this.getResString("modelCode"), "2", "20"}));
            return;
        }
        if (!StringUtil.isBlank((String)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        this.modelBiz.saveEntity(model);
        this.outJson(response, ModelCode.ROLE, true, String.valueOf(model.getModelId()));
    }

    @RequestMapping(value={"/queryAll"})
    public void queryAll(HttpServletResponse response) {
        List modelList = this.modelBiz.queryAll();
        this.outJson(response, JSONObject.toJSONString((Object)modelList));
    }

    @RequestMapping(value={"/edit/{modelId}"})
    @ResponseBody
    public Map edit(@PathVariable int modelId) {
        HashMap<String, Object> mode = new HashMap<String, Object>();
        List allModel = this.modelBiz.queryAll();
        mode.clear();
        ModelEntity model = (ModelEntity)this.modelBiz.getEntity(modelId);
        ModelEntity parentModel = (ModelEntity)this.modelBiz.getEntity(model.getModelModelId());
        mode.put("allModel", allModel);
        mode.put("parentModel", (Object)parentModel);
        mode.put("model", (Object)model);
        return mode;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute ModelEntity model, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)model.getModelTitle(), (int)2, (int)20) || !StringUtil.checkLength((String)model.getModelCode(), (int)2, (int)20)) {
            return;
        }
        if (!StringUtil.isBlank((String)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        this.modelBiz.updateEntity(model);
        this.outJson(response, ModelCode.ROLE, true, String.valueOf(model.getModelId()));
    }

    @RequestMapping(value={"/list"})
    public String list(ModelMap mode, HttpServletRequest request) {
        List parentModelList = this.modelBiz.queryAll();
        mode.addAttribute("parentModelList", (Object)JSONArray.toJSONString((Object)parentModelList));
        return "/manager/model/model_list";
    }

    @RequestMapping(value={"/{modelId}/childlist"})
    @ResponseBody
    public Map childList(@PathVariable int modelId, HttpServletResponse response) {
        HashMap<String, List<BaseEntity>> model = new HashMap<String, List<BaseEntity>>();
        List<BaseEntity> childModelList = this.modelBiz.queryChildList(modelId);
        model.put("chileModelList", childModelList);
        return model;
    }

    @RequestMapping(value={"/{modelId}/isChildModel"})
    @ResponseBody
    public void isChildModel(@PathVariable int modelId, HttpServletResponse response) {
        int childCount = this.modelBiz.queryChildList(modelId).size();
        if (childCount > 0) {
            this.outJson(response, true);
        } else {
            this.outJson(response, modelId);
        }
    }

    @RequestMapping(value={"/{modelId}/delete"})
    @ResponseBody
    public void delete(@PathVariable int modelId, HttpServletResponse response) {
        ModelEntity model = (ModelEntity)this.modelBiz.getEntity(modelId);
        this.modelBiz.deleteEntity(modelId);
        this.outJson(response, ModelCode.ROLE, true, String.valueOf(model.getModelModelId()));
    }

    @RequestMapping(value={"/{managerId}/queryModelByRoleId"})
    public void queryModelByRoleId(@PathVariable int managerId, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity manager = (ManagerEntity)this.managerBiz.getEntity(managerId);
        if (manager == null) {
            return;
        }
        List<Object> modelList = new ArrayList();
        modelList = this.modelBiz.queryModelByRoleId(manager.getManagerRoleID());
        this.outJson(response, null, true, JSONObject.toJSONString(modelList));
    }
}

