/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.CategoryEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/manager/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @RequestMapping(value={"/add"})
    public String add(HttpServletRequest request) {
        String categoryCategoryId = request.getParameter("categoryCategoryId");
        CategoryEntity category = new CategoryEntity();
        if (!StringUtil.isBlank((String)categoryCategoryId)) {
            category.setCategoryCategoryId(Integer.parseInt(categoryCategoryId));
        }
        category.setCategoryManagerId(this.getManagerId(request));
        category.setCategoryModelId(this.getModelCodeId(request));
        List<CategoryEntity> list = this.categoryBiz.queryChilds(category);
        String listJsonString = JSONObject.toJSON(list).toString();
        request.setAttribute("categoryCategoryId", (Object)categoryCategoryId);
        request.setAttribute("listCategory", (Object)listJsonString);
        request.setAttribute("modelTitle", (Object)request.getParameter("modelTitle"));
        request.setAttribute("modelId", (Object)request.getParameter("modelId"));
        return "/manager/category/category_form";
    }

    @RequestMapping(value={"/save"})
    public void save(@ModelAttribute CategoryEntity category, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkForm(category, response)) {
            return;
        }
        category.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        category.setCategoryDateTime(new Timestamp(System.currentTimeMillis()));
        category.setCategoryAppId(this.getAppId(request));
        category.setCategoryModelId(this.getModelCodeId(request));
        this.categoryBiz.saveCategoryEntity(category);
        this.outJson(response, ModelCode.CMS_COLUMN, true, null, String.valueOf(category.getCategoryId()));
    }

    @RequestMapping(value={"/{categoryId}/edit"})
    public String edit(@PathVariable int categoryId, HttpServletRequest request) {
        List<Object> list = new ArrayList();
        CategoryEntity category = new CategoryEntity();
        category.setCategoryManagerId(this.getManagerId(request));
        category.setCategoryModelId(this.getModelCodeId(request));
        list = this.categoryBiz.queryChilds(category);
        CategoryEntity column = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        request.setAttribute("category", (Object)column);
        if (column.getCategoryCategoryId() != 0) {
            CategoryEntity columnSuper = (CategoryEntity)this.categoryBiz.getEntity(column.getCategoryCategoryId());
            request.setAttribute("columnSuper", (Object)columnSuper);
        }
        String listJsonString = JSONObject.toJSON(list).toString();
        request.setAttribute("listCategory", (Object)listJsonString);
        request.setAttribute("modelTitle", (Object)request.getParameter("modelTitle"));
        request.setAttribute("modelId", (Object)request.getParameter("modelId"));
        return "/manager/category/category_form";
    }

    @RequestMapping(value={"/update"})
    public void update(@ModelAttribute CategoryEntity category, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkForm(category, response)) {
            return;
        }
        category.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        this.categoryBiz.updateCategoryEntity(category);
        this.outJson(response, ModelCode.CMS_COLUMN, true, null, JSONArray.toJSONString((Object)category.getCategoryId()));
    }

    @RequestMapping(value={"/list"})
    public String list(HttpServletRequest request, HttpServletResponse response) {
        String modelId = request.getParameter("modelId");
        String categoryCategoryId = request.getParameter("categoryCategoryId");
        this.setSession(request, SessionConstEnum.MANAGER_MODEL_CODE, modelId);
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        CategoryEntity category = new CategoryEntity();
        category.setCategoryModelId(Integer.parseInt(modelId));
        AppEntity app = this.getApp(request);
        category.setCategoryAppId(app.getAppId());
        if (managerSession.getManagerId() != app.getAppManagerId()) {
            category.setCategoryManagerId(managerSession.getManagerId());
        }
        PageUtil page = new PageUtil(0, 1000, "");
        List list = this.categoryBiz.queryByPageList(category, page, "category_id", true);
        this.setCookie(request, response, CookieConstEnum.BACK_COOKIE, "/manager/category/list.do");
        request.setAttribute("categoryCategoryId", (Object)categoryCategoryId);
        request.setAttribute("categoryJson", (Object)JSONArray.toJSONString((Object)list));
        request.setAttribute("modelId", (Object)request.getParameter("modelId"));
        return "/manager/category/category_list";
    }

    @RequestMapping(value={"/{categoryId}/delete"})
    public void delete(@PathVariable int categoryId, HttpServletResponse response, HttpServletRequest request) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryCategoryId(categoryId);
        category.setCategoryManagerId(this.getManagerId(request));
        category.setCategoryModelId(this.getModelCodeId(request));
        if (this.categoryBiz.count(category) > 0) {
            this.outJson(response, ModelCode.CMS_COLUMN, true, "0");
        } else {
            this.categoryBiz.deleteCategoryEntity(categoryId);
            this.outJson(response, ModelCode.CMS_COLUMN, true, "1");
        }
    }

    private boolean checkForm(CategoryEntity category, HttpServletResponse response) {
        if (StringUtil.isBlank((String)category.getCategoryTitle())) {
            this.outJson(response, ModelCode.CMS_COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("categoryTitle")}));
            return false;
        }
        if (!StringUtil.checkLength((String)category.getCategoryTitle(), (int)1, (int)31)) {
            this.outJson(response, ModelCode.CMS_COLUMN, false, this.getResString("err.length", new String[]{this.getResString("categoryTitle"), "1", "30"}));
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/{categoryId}/query"})
    public void query(@PathVariable int categoryId, HttpServletRequest request, ModelMap mode, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category == null) {
            return;
        }
        CategoryEntity categoryCategory = (CategoryEntity)this.categoryBiz.getEntity(category.getCategoryCategoryId());
        ArrayList<CategoryEntity> list = new ArrayList<CategoryEntity>();
        list.add(categoryCategory);
        list.add(category);
        this.outJson(response, JSONObject.toJSONString(list));
    }

    @RequestMapping(value={"/{categoryId}/queryChildren"})
    public void queryChildren(@PathVariable int categoryId, HttpServletRequest request, ModelMap mode, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category != null) {
            List<CategoryEntity> list = this.categoryBiz.queryChilds(category);
            this.outJson(response, JSONObject.toJSONString(list));
        }
    }

    @RequestMapping(value={"/{categoryId}/childList"})
    public String childList(@PathVariable int categoryId, HttpServletRequest request, HttpServletResponse response) {
        String modelId = request.getParameter("modelId");
        String categoryCategoryId = request.getParameter("categoryCategoryId");
        this.setSession(request, SessionConstEnum.MANAGER_MODEL_CODE, modelId);
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        CategoryEntity category = new CategoryEntity();
        category.setCategoryModelId(Integer.parseInt(modelId));
        AppEntity app = this.getApp(request);
        int appId = app.getAppId();
        category.setCategoryAppId(appId);
        if (managerSession.getManagerId() != app.getAppManagerId()) {
            category.setCategoryManagerId(managerSession.getManagerId());
        }
        List<CategoryEntity> list = this.categoryBiz.queryChildrenCategory(categoryId, appId, this.getModelCodeId(request));
        this.setCookie(request, response, CookieConstEnum.BACK_COOKIE, "/manager/category/list.do");
        request.setAttribute("categoryCategoryId", (Object)categoryCategoryId);
        request.setAttribute("categoryJson", (Object)JSONArray.toJSONString(list));
        request.setAttribute("modelId", (Object)request.getParameter("modelId"));
        return "/manager/category/category_list";
    }
}

