/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics.request;

import com.brsanthu.googleanalytics.GoogleAnalyticsExecutor;
import com.brsanthu.googleanalytics.internal.GaUtils;
import com.brsanthu.googleanalytics.request.GoogleAnalyticsParameter;
import com.brsanthu.googleanalytics.request.GoogleAnalyticsResponse;
import java.util.HashMap;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;

public class GoogleAnalyticsRequest<T> {
    protected Map<GoogleAnalyticsParameter, String> parms = new HashMap<GoogleAnalyticsParameter, String>();
    protected Map<String, String> customDimensions = new HashMap<String, String>();
    protected Map<String, String> customMetrics = new HashMap<String, String>();
    protected GoogleAnalyticsExecutor delegateExecutor = null;

    public GoogleAnalyticsRequest() {
        this(null, null, null, null);
    }

    public GoogleAnalyticsRequest(String hitType) {
        this(hitType, null, null, null);
    }

    public GoogleAnalyticsRequest(String hitType, String trackingId, String appName, String appVersion) {
        this.hitType(GaUtils.isBlank(hitType) ? "pageview" : hitType);
        this.trackingId(trackingId);
        this.applicationName(appName);
        this.applicationVersion(appVersion);
        this.protocolVersion("1");
    }

    protected T setString(GoogleAnalyticsParameter parameter, String value) {
        if (value == null) {
            this.parms.remove((Object)parameter);
        } else {
            String stringValue = value;
            this.parms.put(parameter, stringValue);
        }
        return (T)this;
    }

    protected String getString(GoogleAnalyticsParameter parameter) {
        return this.parms.get((Object)parameter);
    }

    protected T setInteger(GoogleAnalyticsParameter parameter, Integer value) {
        if (value == null) {
            this.parms.remove((Object)parameter);
        } else {
            String stringValue = this.fromInteger(value);
            this.parms.put(parameter, stringValue);
        }
        return (T)this;
    }

    protected Double getDouble(GoogleAnalyticsParameter parameter) {
        return this.toDouble(this.parms.get((Object)parameter));
    }

    protected T setDouble(GoogleAnalyticsParameter parameter, Double value) {
        if (value == null) {
            this.parms.remove((Object)parameter);
        } else {
            String stringValue = this.fromDouble(value);
            this.parms.put(parameter, stringValue);
        }
        return (T)this;
    }

    protected Boolean getBoolean(GoogleAnalyticsParameter parameter) {
        return this.toBoolean(this.parms.get((Object)parameter));
    }

    protected T setBoolean(GoogleAnalyticsParameter parameter, Boolean value) {
        if (value == null) {
            this.parms.remove((Object)parameter);
        } else {
            String stringValue = this.fromBoolean(value);
            this.parms.put(parameter, stringValue);
        }
        return (T)this;
    }

    protected Integer getInteger(GoogleAnalyticsParameter parameter) {
        return this.toInteger(this.parms.get((Object)parameter));
    }

    protected String fromBoolean(Boolean booleanString) {
        if (booleanString == null) {
            return null;
        }
        return "" + booleanString;
    }

    protected Boolean toBoolean(String booleanString) {
        if (GaUtils.isBlank(booleanString)) {
            return null;
        }
        return (boolean)new Boolean(booleanString);
    }

    protected String fromInteger(Integer intValue) {
        if (intValue == null) {
            return null;
        }
        return "" + intValue;
    }

    protected Integer toInteger(String intString) {
        if (GaUtils.isBlank(intString)) {
            return null;
        }
        return Integer.parseInt(intString);
    }

    protected String fromDouble(Double doubleValue) {
        if (doubleValue == null) {
            return null;
        }
        return "" + doubleValue;
    }

    protected Double toDouble(String doubleString) {
        if (GaUtils.isBlank(doubleString)) {
            return null;
        }
        return Double.parseDouble(doubleString);
    }

    protected T parameter(GoogleAnalyticsParameter parameter, String value) {
        if (value == null) {
            this.parms.remove((Object)parameter);
        } else {
            this.parms.put(parameter, value);
        }
        return (T)this;
    }

    protected String parameter(GoogleAnalyticsParameter parameter) {
        return this.parms.get((Object)parameter);
    }

    public Map<GoogleAnalyticsParameter, String> getParameters() {
        return this.parms;
    }

    public String customDimension(int index) {
        return this.customDimensions.get("cd" + index);
    }

    public T customDimension(int index, String value) {
        this.customDimensions.put("cd" + index, value);
        return (T)this;
    }

    public T customMetric(int index, String value) {
        this.customMetrics.put("cm" + index, value);
        return (T)this;
    }

    public String customMetric(int index) {
        return this.customMetrics.get("cm" + index);
    }

    public Map<String, String> customDimensions() {
        return this.customDimensions;
    }

    public Map<String, String> custommMetrics() {
        return this.customMetrics;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Request [");
        if (this.parms != null) {
            builder.append("parms=");
            builder.append(this.parms);
            builder.append(", ");
        }
        if (this.customDimensions != null) {
            builder.append("customDimensions=");
            builder.append(this.customDimensions);
            builder.append(", ");
        }
        if (this.customMetrics != null) {
            builder.append("customMetrics=");
            builder.append(this.customMetrics);
        }
        builder.append("]");
        return builder.toString();
    }

    public T protocolVersion(String value) {
        this.setString(GoogleAnalyticsParameter.PROTOCOL_VERSION, value);
        return (T)this;
    }

    public String protocolVersion() {
        return this.getString(GoogleAnalyticsParameter.PROTOCOL_VERSION);
    }

    public T trackingId(String value) {
        this.setString(GoogleAnalyticsParameter.TRACKING_ID, value);
        return (T)this;
    }

    public String trackingId() {
        return this.getString(GoogleAnalyticsParameter.TRACKING_ID);
    }

    public T anonymizeIp(Boolean value) {
        this.setBoolean(GoogleAnalyticsParameter.ANONYMIZE_IP, value);
        return (T)this;
    }

    public Boolean anonymizeIp() {
        return this.getBoolean(GoogleAnalyticsParameter.ANONYMIZE_IP);
    }

    public T dataSource(String value) {
        this.setString(GoogleAnalyticsParameter.DATA_SOURCE, value);
        return (T)this;
    }

    public String dataSource() {
        return this.getString(GoogleAnalyticsParameter.DATA_SOURCE);
    }

    public T queueTime(Integer value) {
        this.setInteger(GoogleAnalyticsParameter.QUEUE_TIME, value);
        return (T)this;
    }

    public Integer queueTime() {
        return this.getInteger(GoogleAnalyticsParameter.QUEUE_TIME);
    }

    public T cacheBuster(String value) {
        this.setString(GoogleAnalyticsParameter.CACHE_BUSTER, value);
        return (T)this;
    }

    public String cacheBuster() {
        return this.getString(GoogleAnalyticsParameter.CACHE_BUSTER);
    }

    public T clientId(String value) {
        this.setString(GoogleAnalyticsParameter.CLIENT_ID, value);
        return (T)this;
    }

    public String clientId() {
        return this.getString(GoogleAnalyticsParameter.CLIENT_ID);
    }

    public T userId(String value) {
        this.setString(GoogleAnalyticsParameter.USER_ID, value);
        return (T)this;
    }

    public String userId() {
        return this.getString(GoogleAnalyticsParameter.USER_ID);
    }

    public T sessionControl(String value) {
        this.setString(GoogleAnalyticsParameter.SESSION_CONTROL, value);
        return (T)this;
    }

    public String sessionControl() {
        return this.getString(GoogleAnalyticsParameter.SESSION_CONTROL);
    }

    public T documentReferrer(String value) {
        this.setString(GoogleAnalyticsParameter.DOCUMENT_REFERRER, value);
        return (T)this;
    }

    public String documentReferrer() {
        return this.getString(GoogleAnalyticsParameter.DOCUMENT_REFERRER);
    }

    public T campaignName(String value) {
        this.setString(GoogleAnalyticsParameter.CAMPAIGN_NAME, value);
        return (T)this;
    }

    public String campaignName() {
        return this.getString(GoogleAnalyticsParameter.CAMPAIGN_NAME);
    }

    public T campaignSource(String value) {
        this.setString(GoogleAnalyticsParameter.CAMPAIGN_SOURCE, value);
        return (T)this;
    }

    public String campaignSource() {
        return this.getString(GoogleAnalyticsParameter.CAMPAIGN_SOURCE);
    }

    public T campaignMedium(String value) {
        this.setString(GoogleAnalyticsParameter.CAMPAIGN_MEDIUM, value);
        return (T)this;
    }

    public String campaignMedium() {
        return this.getString(GoogleAnalyticsParameter.CAMPAIGN_MEDIUM);
    }

    public T campaignKeyword(String value) {
        this.setString(GoogleAnalyticsParameter.CAMPAIGN_KEYWORD, value);
        return (T)this;
    }

    public String campaignKeyword() {
        return this.getString(GoogleAnalyticsParameter.CAMPAIGN_KEYWORD);
    }

    public T campaignContent(String value) {
        this.setString(GoogleAnalyticsParameter.CAMPAIGN_CONTENT, value);
        return (T)this;
    }

    public String campaignContent() {
        return this.getString(GoogleAnalyticsParameter.CAMPAIGN_CONTENT);
    }

    public T campaignId(String value) {
        this.setString(GoogleAnalyticsParameter.CAMPAIGN_ID, value);
        return (T)this;
    }

    public String campaignId() {
        return this.getString(GoogleAnalyticsParameter.CAMPAIGN_ID);
    }

    public T adwordsId(String value) {
        this.setString(GoogleAnalyticsParameter.ADWORDS_ID, value);
        return (T)this;
    }

    public String adwordsId() {
        return this.getString(GoogleAnalyticsParameter.ADWORDS_ID);
    }

    public T displayadId(String value) {
        this.setString(GoogleAnalyticsParameter.DISPLAY_ADS_ID, value);
        return (T)this;
    }

    public String displayadId() {
        return this.getString(GoogleAnalyticsParameter.DISPLAY_ADS_ID);
    }

    public T screenResolution(String value) {
        this.setString(GoogleAnalyticsParameter.SCREEN_RESOLUTION, value);
        return (T)this;
    }

    public String screenResolution() {
        return this.getString(GoogleAnalyticsParameter.SCREEN_RESOLUTION);
    }

    public T viewportSize(String value) {
        this.setString(GoogleAnalyticsParameter.VIEWPORT_SIZE, value);
        return (T)this;
    }

    public String viewportSize() {
        return this.getString(GoogleAnalyticsParameter.VIEWPORT_SIZE);
    }

    public T documentEncoding(String value) {
        this.setString(GoogleAnalyticsParameter.DOCUMENT_ENCODING, value);
        return (T)this;
    }

    public String documentEncoding() {
        return this.getString(GoogleAnalyticsParameter.DOCUMENT_ENCODING);
    }

    public T screenColors(String value) {
        this.setString(GoogleAnalyticsParameter.SCREEN_COLORS, value);
        return (T)this;
    }

    public String screenColors() {
        return this.getString(GoogleAnalyticsParameter.SCREEN_COLORS);
    }

    public T userLanguage(String value) {
        this.setString(GoogleAnalyticsParameter.USER_LANGUAGE, value);
        return (T)this;
    }

    public String userLanguage() {
        return this.getString(GoogleAnalyticsParameter.USER_LANGUAGE);
    }

    public T javaEnabled(Boolean value) {
        this.setBoolean(GoogleAnalyticsParameter.JAVA_ENABLED, value);
        return (T)this;
    }

    public Boolean javaEnabled() {
        return this.getBoolean(GoogleAnalyticsParameter.JAVA_ENABLED);
    }

    public T flashVersion(String value) {
        this.setString(GoogleAnalyticsParameter.FLASH_VERSION, value);
        return (T)this;
    }

    public String flashVersion() {
        return this.getString(GoogleAnalyticsParameter.FLASH_VERSION);
    }

    public T hitType(String value) {
        this.setString(GoogleAnalyticsParameter.HIT_TYPE, value);
        return (T)this;
    }

    public String hitType() {
        return this.getString(GoogleAnalyticsParameter.HIT_TYPE);
    }

    public T nonInteractionHit(String value) {
        this.setString(GoogleAnalyticsParameter.NON_INTERACTION_HIT, value);
        return (T)this;
    }

    public String nonInteractionHit() {
        return this.getString(GoogleAnalyticsParameter.NON_INTERACTION_HIT);
    }

    public T documentUrl(String value) {
        this.setString(GoogleAnalyticsParameter.DOCUMENT_URL, value);
        return (T)this;
    }

    public String documentUrl() {
        return this.getString(GoogleAnalyticsParameter.DOCUMENT_URL);
    }

    public T documentHostName(String value) {
        this.setString(GoogleAnalyticsParameter.DOCUMENT_HOST_NAME, value);
        return (T)this;
    }

    public String documentHostName() {
        return this.getString(GoogleAnalyticsParameter.DOCUMENT_HOST_NAME);
    }

    public T documentPath(String value) {
        this.setString(GoogleAnalyticsParameter.DOCUMENT_PATH, value);
        return (T)this;
    }

    public String documentPath() {
        return this.getString(GoogleAnalyticsParameter.DOCUMENT_PATH);
    }

    public T documentTitle(String value) {
        this.setString(GoogleAnalyticsParameter.DOCUMENT_TITLE, value);
        return (T)this;
    }

    public String documentTitle() {
        return this.getString(GoogleAnalyticsParameter.DOCUMENT_TITLE);
    }

    public T contentDescription(String value) {
        this.setString(GoogleAnalyticsParameter.CONTENT_DESCRIPTION, value);
        return (T)this;
    }

    public String contentDescription() {
        return this.getString(GoogleAnalyticsParameter.CONTENT_DESCRIPTION);
    }

    public T applicationName(String value) {
        this.setString(GoogleAnalyticsParameter.APPLICATION_NAME, value);
        return (T)this;
    }

    public String applicationName() {
        return this.getString(GoogleAnalyticsParameter.APPLICATION_NAME);
    }

    public T applicationInstallerId(String value) {
        this.setString(GoogleAnalyticsParameter.APPLICATION_INSTALLER_ID, value);
        return (T)this;
    }

    public String applicationInstallerId() {
        return this.getString(GoogleAnalyticsParameter.APPLICATION_INSTALLER_ID);
    }

    public T applicationVersion(String value) {
        this.setString(GoogleAnalyticsParameter.APPLICATION_VERSION, value);
        return (T)this;
    }

    public String applicationVersion() {
        return this.getString(GoogleAnalyticsParameter.APPLICATION_VERSION);
    }

    public T applicationId(String value) {
        this.setString(GoogleAnalyticsParameter.APPLICATION_ID, value);
        return (T)this;
    }

    public String applicationId() {
        return this.getString(GoogleAnalyticsParameter.APPLICATION_ID);
    }

    public T experimentId(String value) {
        this.setString(GoogleAnalyticsParameter.EXPERIMENT_ID, value);
        return (T)this;
    }

    public String experimentId() {
        return this.getString(GoogleAnalyticsParameter.EXPERIMENT_ID);
    }

    public T experimentVariant(String value) {
        this.setString(GoogleAnalyticsParameter.EXPERIMENT_VARIANT, value);
        return (T)this;
    }

    public String experimentVariant() {
        return this.getString(GoogleAnalyticsParameter.EXPERIMENT_VARIANT);
    }

    public T userIp(String value) {
        this.setString(GoogleAnalyticsParameter.USER_IP, value);
        return (T)this;
    }

    public String userIp() {
        return this.getString(GoogleAnalyticsParameter.USER_IP);
    }

    public T userAgent(String value) {
        this.setString(GoogleAnalyticsParameter.USER_AGENT, value);
        return (T)this;
    }

    public String userAgent() {
        return this.getString(GoogleAnalyticsParameter.USER_AGENT);
    }

    public T geoid(String value) {
        this.setString(GoogleAnalyticsParameter.GEOID, value);
        return (T)this;
    }

    public String geoid() {
        return this.getString(GoogleAnalyticsParameter.GEOID);
    }

    public GoogleAnalyticsResponse send() {
        if (this.delegateExecutor == null) {
            throw new RuntimeException("GoogleAnalyticsExecutor is null");
        }
        return this.delegateExecutor.post(this);
    }

    public CompletableFuture<GoogleAnalyticsResponse> sendAsync() {
        if (this.delegateExecutor == null) {
            throw new RuntimeException("GoogleAnalyticsExecutor is null");
        }
        return this.delegateExecutor.postAsync(this);
    }

    public GoogleAnalyticsRequest<T> setExecutor(GoogleAnalyticsExecutor delegateExecutor) {
        this.delegateExecutor = delegateExecutor;
        return this;
    }
}

