/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics.httpclient;

import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.httpclient.HttpBatchRequest;
import com.brsanthu.googleanalytics.httpclient.HttpBatchResponse;
import com.brsanthu.googleanalytics.httpclient.HttpClient;
import com.brsanthu.googleanalytics.httpclient.HttpRequest;
import com.brsanthu.googleanalytics.httpclient.HttpResponse;
import com.brsanthu.googleanalytics.internal.GaUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientImpl
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpClientImpl.class);
    private static OkHttpClient client;

    public OkHttpClientImpl(GoogleAnalyticsConfig config) {
        if (client == null) {
            client = this.createHttpClient(config);
        }
    }

    @Override
    public void close() throws Exception {
    }

    protected OkHttpClient createHttpClient(final GoogleAnalyticsConfig config) throws RuntimeException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.checkConfigForUnsupportedConfiguration(config);
        if (GaUtils.isNotEmpty(config.getProxyHost())) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxyHost(), config.getProxyPort())));
            if (GaUtils.isNotEmpty(config.getProxyUserName())) {
                Authenticator proxyAuthenticator = new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        String credential = Credentials.basic((String)config.getProxyUserName(), (String)config.getProxyPassword());
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        return builder.build();
    }

    private void checkConfigForUnsupportedConfiguration(GoogleAnalyticsConfig config) throws RuntimeException {
        if (config.getMaxHttpConnectionsPerRoute() != 10) {
            throw new RuntimeException("Configuring maximum connections per route is not supported by OkHttp");
        }
        if (GaUtils.isNotEmpty(config.getUserAgent())) {
            throw new RuntimeException("GoogleAnalyticsConfig.userAgent is not currently supported");
        }
    }

    @Override
    public CompletableFuture<HttpResponse> post(HttpRequest req) {
        FormBody.Builder formBuilder = new FormBody.Builder(Charset.forName("UTF-8"));
        Map<String, String> reqParams = req.getBodyParams();
        for (String key : reqParams.keySet()) {
            if (logger.isTraceEnabled()) {
                logger.trace("post() adding POST param " + key + " = " + reqParams.get(key));
            }
            formBuilder.add(key, reqParams.get(key));
        }
        FormBody body = formBuilder.build();
        Request request = new Request.Builder().url(req.getUrl()).post((RequestBody)body).build();
        if (logger.isDebugEnabled()) {
            logger.debug("HttpClient.post() url/body: " + request.url() + " / " + this.renderBody((RequestBody)body));
        }
        final CompletableFuture completableFuture = new CompletableFuture();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                logger.warn("OkHttpClientImpl.post()/OkHttpClient.newCall() error", (Throwable)e);
                completableFuture.completeExceptionally((Throwable)e);
            }

            public void onResponse(Call call, Response okResp) {
                if (logger.isDebugEnabled()) {
                    logger.debug("post() response code/success: " + okResp.code() + " / " + okResp.isSuccessful());
                }
                HttpResponse resp = new HttpResponse();
                resp.setStatusCode(okResp.code());
                okResp.close();
                completableFuture.complete((Object)resp);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<HttpBatchResponse> postBatch(HttpBatchRequest batchReq) {
        Buffer bodyBuffer = new Buffer();
        for (HttpRequest request : batchReq.getRequests()) {
            FormBody.Builder formBuilder = new FormBody.Builder(Charset.forName("UTF-8"));
            if (logger.isTraceEnabled()) {
                logger.trace("postBatch() starting new request line");
            }
            Map<String, String> reqParams = request.getBodyParams();
            for (String key : reqParams.keySet()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("postBatch() adding POST param " + key + " = " + reqParams.get(key));
                }
                formBuilder.add(key, reqParams.get(key));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("postBatch() finishing request line");
            }
            try {
                formBuilder.build().writeTo((BufferedSink)bodyBuffer);
            }
            catch (IOException ioe) {
                logger.warn("postBatch() error while rendering batch entry", (Throwable)ioe);
            }
            bodyBuffer.writeString("\r\n", Charset.forName("UTF-8"));
        }
        Request request = new Request.Builder().url(batchReq.getUrl()).post(RequestBody.create(null, (String)bodyBuffer.readUtf8())).build();
        if (logger.isDebugEnabled()) {
            logger.debug("HttpClient.postBatch() url/body: " + request.url() + " / " + this.renderBody(request.body()));
        }
        final CompletableFuture completableFuture = new CompletableFuture();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                logger.warn("OkHttpClientImpl.postBatch()/OkHttpClient.newCall() error", (Throwable)e);
                completableFuture.completeExceptionally((Throwable)e);
            }

            public void onResponse(Call call, Response okResp) {
                if (logger.isDebugEnabled()) {
                    logger.debug("postBatch() response code/success: " + okResp.code() + " / " + okResp.isSuccessful());
                }
                HttpBatchResponse resp = new HttpBatchResponse();
                resp.setStatusCode(okResp.code());
                okResp.close();
                completableFuture.complete((Object)resp);
            }
        });
        return completableFuture;
    }

    @Override
    public boolean isBatchSupported() {
        return true;
    }

    private String renderBody(RequestBody requestBody) {
        try {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException ioe) {
            logger.warn("renderBody() error writing body contents out", (Throwable)ioe);
            return "";
        }
    }
}

