/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics.httpclient;

import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.httpclient.BatchUrlEncodedFormEntity;
import com.brsanthu.googleanalytics.httpclient.GoogleAnalyticsThreadFactory;
import com.brsanthu.googleanalytics.httpclient.HttpBatchRequest;
import com.brsanthu.googleanalytics.httpclient.HttpBatchResponse;
import com.brsanthu.googleanalytics.httpclient.HttpClient;
import com.brsanthu.googleanalytics.httpclient.HttpRequest;
import com.brsanthu.googleanalytics.httpclient.HttpResponse;
import com.brsanthu.googleanalytics.internal.GaUtils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java8.util.concurrent.CompletableFuture;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientImpl
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClientImpl.class);
    private CloseableHttpClient apacheHttpClient;
    protected final ExecutorService executor;

    public ApacheHttpClientImpl(GoogleAnalyticsConfig config) {
        this.apacheHttpClient = this.createHttpClient(config);
        this.executor = this.createExecutor(config);
    }

    @Override
    public void close() {
        try {
            this.apacheHttpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected CloseableHttpClient createHttpClient(GoogleAnalyticsConfig config) {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(Math.max(config.getMaxHttpConnectionsPerRoute(), 1));
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        if (GaUtils.isNotEmpty(config.getUserAgent())) {
            builder.setUserAgent(config.getUserAgent());
        }
        if (GaUtils.isNotEmpty(config.getProxyHost())) {
            builder.setProxy(new HttpHost(config.getProxyHost(), config.getProxyPort()));
            if (GaUtils.isNotEmpty(config.getProxyUserName())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUserName(), config.getProxyPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return builder.build();
    }

    @Override
    public boolean isBatchSupported() {
        return true;
    }

    protected CloseableHttpResponse execute(String url, HttpEntity entity) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        return this.apacheHttpClient.execute((HttpUriRequest)httpPost);
    }

    protected List<NameValuePair> createNameValuePairs(HttpRequest req) {
        CopyOnWriteArrayList<NameValuePair> params = new CopyOnWriteArrayList<NameValuePair>();
        req.getBodyParams().forEach((key, value) -> params.add((NameValuePair)new BasicNameValuePair(key, value)));
        return params;
    }

    @Override
    public CompletableFuture<HttpResponse> post(HttpRequest req) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse resp = new HttpResponse();
            CloseableHttpResponse httpResp = null;
            try {
                httpResp = this.execute(req.getUrl(), (HttpEntity)new UrlEncodedFormEntity(this.createNameValuePairs(req), StandardCharsets.UTF_8));
                resp.setStatusCode(httpResp.getStatusLine().getStatusCode());
            }
            catch (Exception e) {
                if (e instanceof UnknownHostException) {
                    logger.warn("Couldn't connect to Google Analytics. Internet may not be available. " + e.toString());
                } else {
                    logger.warn("Exception while sending the Google Analytics tracker request " + req, (Throwable)e);
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)httpResp.getEntity());
                try {
                    httpResp.close();
                }
                catch (Exception exception) {}
            }
            return resp;
        });
    }

    @Override
    public CompletableFuture<HttpBatchResponse> postBatch(HttpBatchRequest req) {
        return CompletableFuture.supplyAsync(() -> {
            HttpBatchResponse resp = new HttpBatchResponse();
            CloseableHttpResponse httpResp = null;
            try {
                CopyOnWriteArrayList<HttpRequest> reqs = new CopyOnWriteArrayList<HttpRequest>(req.getRequests());
                List<List<NameValuePair>> listOfReqPairs = reqs.stream().map(this::createNameValuePairs).collect(Collectors.toList());
                httpResp = this.execute(req.getUrl(), (HttpEntity)new BatchUrlEncodedFormEntity(listOfReqPairs));
                resp.setStatusCode(httpResp.getStatusLine().getStatusCode());
            }
            catch (Exception e) {
                if (e instanceof UnknownHostException) {
                    logger.warn("Couldn't connect to Google Analytics. Internet may not be available. " + e.toString());
                } else {
                    logger.warn("Exception while sending the Google Analytics tracker request " + req, (Throwable)e);
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)httpResp.getEntity());
                try {
                    httpResp.close();
                }
                catch (Exception exception) {}
            }
            return resp;
        });
    }

    protected ExecutorService createExecutor(GoogleAnalyticsConfig config) {
        if (this.executor != null) {
            return this.executor;
        }
        return new ThreadPoolExecutor(config.getMinThreads(), config.getMaxThreads(), config.getThreadTimeoutSecs(), TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(config.getThreadQueueSize()), this.createThreadFactory(config), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected ThreadFactory createThreadFactory(GoogleAnalyticsConfig config) {
        return new GoogleAnalyticsThreadFactory(config.getThreadNameFormat());
    }
}

