/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics.internal;

import com.brsanthu.googleanalytics.GoogleAnalytics;
import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.GoogleAnalyticsExecutor;
import com.brsanthu.googleanalytics.GoogleAnalyticsStats;
import com.brsanthu.googleanalytics.httpclient.HttpBatchRequest;
import com.brsanthu.googleanalytics.httpclient.HttpClient;
import com.brsanthu.googleanalytics.httpclient.HttpRequest;
import com.brsanthu.googleanalytics.httpclient.HttpResponse;
import com.brsanthu.googleanalytics.internal.GaUtils;
import com.brsanthu.googleanalytics.internal.GoogleAnalyticsStatsImpl;
import com.brsanthu.googleanalytics.request.DefaultRequest;
import com.brsanthu.googleanalytics.request.EventHit;
import com.brsanthu.googleanalytics.request.ExceptionHit;
import com.brsanthu.googleanalytics.request.GoogleAnalyticsParameter;
import com.brsanthu.googleanalytics.request.GoogleAnalyticsRequest;
import com.brsanthu.googleanalytics.request.GoogleAnalyticsResponse;
import com.brsanthu.googleanalytics.request.ItemHit;
import com.brsanthu.googleanalytics.request.PageViewHit;
import com.brsanthu.googleanalytics.request.ScreenViewHit;
import com.brsanthu.googleanalytics.request.SocialHit;
import com.brsanthu.googleanalytics.request.TimingHit;
import com.brsanthu.googleanalytics.request.TransactionHit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAnalyticsImpl
implements GoogleAnalytics,
GoogleAnalyticsExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(GoogleAnalyticsImpl.class);
    protected final GoogleAnalyticsConfig config;
    protected final DefaultRequest defaultRequest;
    protected final HttpClient httpClient;
    protected final ExecutorService executor;
    protected boolean inSample = true;
    protected GoogleAnalyticsStatsImpl stats = new GoogleAnalyticsStatsImpl();
    protected List<HttpRequest> currentBatch = new ArrayList<HttpRequest>();

    public GoogleAnalyticsImpl(GoogleAnalyticsConfig config, DefaultRequest defaultRequest, HttpClient httpClient, ExecutorService executor) {
        this.config = config;
        this.defaultRequest = defaultRequest;
        this.httpClient = httpClient;
        this.executor = executor;
        this.performSamplingElection();
    }

    @Override
    public boolean performSamplingElection() {
        int randomNum = new Random().nextInt(100) + 1;
        if (randomNum > this.config.getSamplePercentage()) {
            logger.info("Not participating in analytics sample (sample percentage vs random: " + this.config.getSamplePercentage() + " " + randomNum + ")");
            this.inSample = false;
        } else {
            logger.info("Participating in analytics sample (sample percentage vs random: " + this.config.getSamplePercentage() + " " + randomNum + ")");
            this.inSample = true;
        }
        return this.inSample();
    }

    @Override
    public boolean inSample() {
        return this.inSample;
    }

    @Override
    public GoogleAnalyticsConfig getConfig() {
        return this.config;
    }

    public DefaultRequest getDefaultRequest() {
        return this.defaultRequest;
    }

    @Override
    public Future<GoogleAnalyticsResponse> postAsync(GoogleAnalyticsRequest<?> request) {
        if (!this.config.isEnabled() || !this.inSample()) {
            return null;
        }
        return this.executor.submit(() -> this.post(request));
    }

    @Override
    public GoogleAnalyticsResponse post(GoogleAnalyticsRequest<?> gaReq) {
        GoogleAnalyticsResponse response = new GoogleAnalyticsResponse();
        if (!this.config.isEnabled() || !this.inSample()) {
            return response;
        }
        try {
            response = this.config.isBatchingEnabled() ? this.postBatch(gaReq) : this.postSingle(gaReq);
        }
        catch (Exception e) {
            logger.warn("Exception while sending the Google Analytics tracker request " + gaReq, (Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GoogleAnalyticsResponse postBatch(GoogleAnalyticsRequest<?> gaReq) {
        GoogleAnalyticsResponse resp = new GoogleAnalyticsResponse();
        HttpRequest httpReq = this.createHttpRequest(gaReq);
        resp.setRequestParams(httpReq.getBodyParams());
        if (this.config.isGatherStats()) {
            this.gatherStats(gaReq);
        }
        List<HttpRequest> list = this.currentBatch;
        synchronized (list) {
            this.currentBatch.add(httpReq);
        }
        this.submitBatch(false);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitBatch(boolean force) {
        if (this.currentBatch.isEmpty()) {
            return;
        }
        if (this.isSubmitBatch(force)) {
            List<HttpRequest> list = this.currentBatch;
            synchronized (list) {
                if (this.isSubmitBatch(force)) {
                    logger.debug("Submitting a batch of " + this.currentBatch.size() + " requests to GA");
                    this.httpClient.postBatch(new HttpBatchRequest().setUrl(this.config.getBatchUrl()).setRequests(this.currentBatch));
                    this.currentBatch.clear();
                }
            }
        }
    }

    private boolean isSubmitBatch(boolean force) {
        return force || this.currentBatch.size() >= this.config.getBatchSize();
    }

    protected GoogleAnalyticsResponse postSingle(GoogleAnalyticsRequest<?> gaReq) {
        HttpRequest httpReq = this.createHttpRequest(gaReq);
        HttpResponse httpResp = this.httpClient.post(httpReq);
        GoogleAnalyticsResponse response = new GoogleAnalyticsResponse();
        response.setStatusCode(httpResp.getStatusCode());
        response.setRequestParams(httpReq.getBodyParams());
        if (this.config.isGatherStats()) {
            this.gatherStats(gaReq);
        }
        return response;
    }

    private HttpRequest createHttpRequest(GoogleAnalyticsRequest<?> gaReq) {
        HttpRequest httpReq = new HttpRequest(this.config.getUrl());
        this.processParameters(gaReq, httpReq);
        this.processCustomDimensionParameters(gaReq, httpReq);
        this.processCustomMetricParameters(gaReq, httpReq);
        return httpReq;
    }

    protected void processParameters(GoogleAnalyticsRequest<?> request, HttpRequest req) {
        Map<GoogleAnalyticsParameter, String> requestParms = request.getParameters();
        Map<GoogleAnalyticsParameter, String> defaultParms = this.defaultRequest.getParameters();
        for (GoogleAnalyticsParameter parm : defaultParms.keySet()) {
            String value = requestParms.get((Object)parm);
            String defaultValue = defaultParms.get((Object)parm);
            if (!GaUtils.isEmpty(value) || GaUtils.isEmpty(defaultValue)) continue;
            requestParms.put(parm, defaultValue);
        }
        for (GoogleAnalyticsParameter key : requestParms.keySet()) {
            req.addBodyParam(key.getParameterName(), requestParms.get((Object)key));
        }
    }

    protected void processCustomDimensionParameters(GoogleAnalyticsRequest<?> request, HttpRequest req) {
        HashMap<String, String> customDimParms = new HashMap<String, String>();
        for (String defaultCustomDimKey : this.defaultRequest.customDimensions().keySet()) {
            customDimParms.put(defaultCustomDimKey, this.defaultRequest.customDimensions().get(defaultCustomDimKey));
        }
        Map<String, String> requestCustomDims = request.customDimensions();
        for (String requestCustomDimKey : requestCustomDims.keySet()) {
            customDimParms.put(requestCustomDimKey, requestCustomDims.get(requestCustomDimKey));
        }
        for (String key : customDimParms.keySet()) {
            req.addBodyParam(key, (String)customDimParms.get(key));
        }
    }

    protected void processCustomMetricParameters(GoogleAnalyticsRequest<?> request, HttpRequest req) {
        HashMap<String, String> customMetricParms = new HashMap<String, String>();
        for (String defaultCustomMetricKey : this.defaultRequest.custommMetrics().keySet()) {
            customMetricParms.put(defaultCustomMetricKey, this.defaultRequest.custommMetrics().get(defaultCustomMetricKey));
        }
        Map<String, String> requestCustomMetrics = request.custommMetrics();
        for (String requestCustomDimKey : requestCustomMetrics.keySet()) {
            customMetricParms.put(requestCustomDimKey, requestCustomMetrics.get(requestCustomDimKey));
        }
        for (String key : customMetricParms.keySet()) {
            req.addBodyParam(key, (String)customMetricParms.get(key));
        }
    }

    protected void gatherStats(GoogleAnalyticsRequest<?> request) {
        String hitType = request.hitType();
        if ("pageview".equalsIgnoreCase(hitType)) {
            this.stats.pageViewHit();
        } else if ("screenview".equals(hitType)) {
            this.stats.screenViewHit();
        } else if ("event".equals(hitType)) {
            this.stats.eventHit();
        } else if ("item".equals(hitType)) {
            this.stats.itemHit();
        } else if ("transaction".equals(hitType)) {
            this.stats.transactionHit();
        } else if ("social".equals(hitType)) {
            this.stats.socialHit();
        } else if ("timing".equals(hitType)) {
            this.stats.timingHit();
        } else if ("exception".equals(hitType)) {
            this.stats.exceptionHit();
        }
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.httpClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public GoogleAnalyticsStats getStats() {
        return this.stats;
    }

    @Override
    public void resetStats() {
        this.stats = new GoogleAnalyticsStatsImpl();
    }

    @Override
    public EventHit event() {
        return (EventHit)new EventHit().setExecutor(this);
    }

    @Override
    public ExceptionHit exception() {
        return (ExceptionHit)new ExceptionHit().setExecutor(this);
    }

    @Override
    public ItemHit item() {
        return (ItemHit)new ItemHit().setExecutor(this);
    }

    @Override
    public PageViewHit pageView() {
        return (PageViewHit)new PageViewHit().setExecutor(this);
    }

    @Override
    public PageViewHit pageView(String url, String title) {
        return (PageViewHit)((PageViewHit)this.pageView().documentUrl(url)).documentTitle(title);
    }

    @Override
    public PageViewHit pageView(String url, String title, String description) {
        return (PageViewHit)this.pageView(url, title).contentDescription(description);
    }

    @Override
    public ScreenViewHit screenView() {
        return (ScreenViewHit)new ScreenViewHit().setExecutor(this);
    }

    @Override
    public ScreenViewHit screenView(String appName, String screenName) {
        return ((ScreenViewHit)this.screenView().applicationName(appName)).screenName(screenName);
    }

    @Override
    public SocialHit social() {
        return (SocialHit)new SocialHit().setExecutor(this);
    }

    @Override
    public SocialHit social(String socialNetwork, String socialAction, String socialTarget) {
        return this.social().socialNetwork(socialNetwork).socialAction(socialAction).socialActionTarget(socialTarget);
    }

    @Override
    public TimingHit timing() {
        return (TimingHit)new TimingHit().setExecutor(this);
    }

    @Override
    public TransactionHit transaction() {
        return (TransactionHit)new TransactionHit().setExecutor(this);
    }

    @Override
    public void ifEnabled(Runnable runnable) {
        if (!this.config.isEnabled()) {
            return;
        }
        runnable.run();
    }

    @Override
    public void flush() {
        this.submitBatch(true);
    }
}

