/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents.team;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.util.ColorUtil;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import com.google.common.base.Preconditions;
import net.kyori.adventure.text.format.NamedTextColor;
import net.megavex.scoreboardlibrary.api.team.enums.NameTagVisibility;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;

public class WrapperPlayServerTeamsLegacy
extends PacketWrapper<WrapperPlayServerTeamsLegacy> {
    private final String teamName;
    private final ImmutableTeamProperties<String> properties;
    private final WrapperPlayServerTeams.TeamMode teamMode;

    public WrapperPlayServerTeamsLegacy(String teamName, ImmutableTeamProperties<String> properties, WrapperPlayServerTeams.TeamMode teamMode) {
        super((PacketTypeCommon)PacketType.Play.Server.TEAMS);
        this.teamName = teamName;
        this.properties = properties;
        Preconditions.checkArgument((teamMode == WrapperPlayServerTeams.TeamMode.CREATE || teamMode == WrapperPlayServerTeams.TeamMode.UPDATE ? 1 : 0) != 0);
        this.teamMode = teamMode;
    }

    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            throw new IllegalStateException("Tried to serialize legacy teams packet on 1.13+ server version");
        }
        this.writeString(this.teamName, 16);
        this.writeByte(this.teamMode.ordinal());
        this.writeString((String)this.properties.displayName());
        this.writeString((String)this.properties.prefix());
        this.writeString((String)this.properties.suffix());
        this.writeByte(this.properties.packOptions());
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeString(NameTagVisibility.ALWAYS.key());
            this.writeByte(15);
        } else {
            this.writeString(this.properties.nameTagVisibility().key());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.writeString(this.properties.collisionRule().key());
            }
            this.writeByte(ColorUtil.getId((NamedTextColor)this.properties.playerColor()));
        }
        if (this.teamMode == WrapperPlayServerTeams.TeamMode.CREATE) {
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeShort(this.properties.syncedEntries().size());
            } else {
                this.writeVarInt(this.properties.syncedEntries().size());
            }
            for (String entry : this.properties.syncedEntries()) {
                this.writeString(entry);
            }
        }
    }
}

