/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import net.megavex.scoreboardlibrary.implementation.commons.LineRenderingStrategy;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents.ObjectivePacketAdapterImpl;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents.PacketEventsSender;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents.team.TeamsPacketAdapterImpl;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketAdapterProviderImpl
implements PacketAdapterProvider {
    private final PacketEventsAPI<?> packetEvents = PacketEvents.getAPI();
    private final PacketEventsSender packetSender;

    public PacketAdapterProviderImpl() {
        if (this.packetEvents == null) {
            throw new IllegalStateException("PacketEvents exists in classpath but isn't loaded");
        }
        this.packetSender = new PacketEventsSender(this.packetEvents);
    }

    @NotNull
    public TeamsPacketAdapter createTeamPacketAdapter(@NotNull String teamName) {
        return new TeamsPacketAdapterImpl(this.packetSender, teamName);
    }

    @NotNull
    public ObjectivePacketAdapter createObjectiveAdapter(@NotNull String objectiveName) {
        return new ObjectivePacketAdapterImpl(this.packetSender, this.packetEvents, objectiveName);
    }

    @NotNull
    public LineRenderingStrategy lineRenderingStrategy(@NotNull Player player) {
        ServerVersion serverVer = this.packetEvents.getServerManager().getVersion();
        return serverVer.isNewerThanOrEquals(ServerVersion.V_1_13) ? LineRenderingStrategy.MODERN : LineRenderingStrategy.LEGACY;
    }
}

