/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents;

import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerResetScore;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import net.megavex.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import net.megavex.scoreboardlibrary.api.objective.ObjectiveRenderType;
import net.megavex.scoreboardlibrary.api.objective.ScoreFormat;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.objective.ObjectiveConstants;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.packetevents.ScoreFormatConverter;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.util.LocalePacketUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectivePacketAdapterImpl
implements ObjectivePacketAdapter {
    private final PacketSender<PacketWrapper<?>> provider;
    private final PacketEventsAPI<?> packetEvents;
    private final String objectiveName;
    private WrapperPlayServerScoreboardObjective removePacket;

    public ObjectivePacketAdapterImpl(@NotNull PacketSender<PacketWrapper<?>> provider, @NotNull PacketEventsAPI<?> packetEvents, @NotNull String objectiveName) {
        this.provider = provider;
        this.packetEvents = packetEvents;
        this.objectiveName = objectiveName;
    }

    @NotNull
    public String objectiveName() {
        return this.objectiveName;
    }

    public void display(@NotNull Collection<Player> players, @NotNull ObjectiveDisplaySlot slot) {
        WrapperPlayServerDisplayScoreboard packet = new WrapperPlayServerDisplayScoreboard(ObjectiveConstants.displaySlotIndex((ObjectiveDisplaySlot)slot), this.objectiveName);
        this.provider.sendPacket(players, (Object)packet);
    }

    public void sendProperties(@NotNull Collection<Player> players, @NotNull PropertiesPacketType packetType, @NotNull Component value, @NotNull ObjectiveRenderType renderType, @Nullable ScoreFormat scoreFormat) {
        LocalePacketUtil.sendLocalePackets(this.provider, players, locale -> this.createObjectivePacket((Locale)locale, packetType, value, renderType, scoreFormat));
    }

    public void remove(@NotNull Collection<Player> players) {
        if (this.removePacket == null) {
            this.removePacket = new WrapperPlayServerScoreboardObjective(this.objectiveName, WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE, null, null);
        }
        this.provider.sendPacket(players, (Object)this.removePacket);
    }

    public void sendScore(@NotNull Collection<Player> players, @NotNull String entry, int value, @Nullable Component display, @Nullable ScoreFormat scoreFormat) {
        LocalePacketUtil.sendLocalePackets(this.provider, players, locale -> new WrapperPlayServerUpdateScore(entry, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, this.objectiveName, value, display != null ? GlobalTranslator.render((Component)display, (Locale)locale) : null, ScoreFormatConverter.convert(locale, scoreFormat)));
    }

    public void removeScore(@NotNull Collection<Player> players, @NotNull String entry) {
        WrapperPlayServerUpdateScore oldPacket = new WrapperPlayServerUpdateScore(entry, WrapperPlayServerUpdateScore.Action.REMOVE_ITEM, this.objectiveName, Optional.empty());
        WrapperPlayServerResetScore newPacket = new WrapperPlayServerResetScore(entry, this.objectiveName);
        if (this.packetEvents.getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.provider.sendPacket(players, (Object)newPacket);
        } else {
            this.provider.sendPacket(players, (Object)oldPacket);
        }
    }

    private WrapperPlayServerScoreboardObjective createObjectivePacket(@NotNull Locale locale, @NotNull PropertiesPacketType packetType, @NotNull Component value, @NotNull ObjectiveRenderType renderType, @Nullable ScoreFormat format) {
        WrapperPlayServerScoreboardObjective.RenderType peRenderType;
        WrapperPlayServerScoreboardObjective.ObjectiveMode peMode;
        switch (packetType) {
            case CREATE: {
                peMode = WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE;
                break;
            }
            case UPDATE: {
                peMode = WrapperPlayServerScoreboardObjective.ObjectiveMode.UPDATE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (renderType) {
            case INTEGER: {
                peRenderType = WrapperPlayServerScoreboardObjective.RenderType.INTEGER;
                break;
            }
            case HEARTS: {
                peRenderType = WrapperPlayServerScoreboardObjective.RenderType.HEARTS;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new WrapperPlayServerScoreboardObjective(this.objectiveName, peMode, GlobalTranslator.render((Component)value, (Locale)locale), peRenderType, ScoreFormatConverter.convert(locale, format));
    }
}

