/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.packetAdapter.util.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.util.reflect.ConstructorAccessor;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.util.reflect.FieldAccessor;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.util.reflect.PacketConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectUtil {
    private static final Object UNSAFE;
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodHandle ALLOCATE_INSTANCE_HANDLE;
    private static final MethodType VOID_METHOD_TYPE;
    private static final MethodType VIRTUAL_FIELD_SETTER;

    private ReflectUtil() {
    }

    @NotNull
    public static <T, V> FieldAccessor<T, V> findField(@NotNull Class<T> clazz, @NotNull String name, @NotNull Class<V> valueClass) {
        return ReflectUtil.findField(clazz, new String[]{name}, valueClass);
    }

    @NotNull
    public static <T, V> FieldAccessor<T, V> findField(@NotNull Class<T> clazz, @NotNull String[] names, @NotNull Class<V> valueClass) {
        for (String name : names) {
            try {
                MethodHandle setter = LOOKUP.findSetter(clazz, name, valueClass).asType(VIRTUAL_FIELD_SETTER);
                return new FieldAccessor(setter);
            }
            catch (NoSuchFieldException setter) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("couldn't get field accessor", e);
            }
        }
        throw new IllegalStateException("couldn't find field on class " + clazz.getSimpleName() + " with names " + Arrays.toString(names));
    }

    @NotNull
    public static <T> ConstructorAccessor<T> findConstructorOrThrow(@NotNull Class<T> clazz, Class<?> ... args) {
        ConstructorAccessor<T> accessor = ReflectUtil.findConstructor(clazz, args);
        if (accessor == null) {
            throw new IllegalStateException("couldn't get constructor accessor for class " + clazz.getSimpleName());
        }
        return accessor;
    }

    @Nullable
    public static <T> ConstructorAccessor<T> findConstructor(@NotNull Class<T> clazz, Class<?> ... args) {
        try {
            MethodHandle handle = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, args));
            return new ConstructorAccessor(ReflectUtil.convertToGeneric(handle));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    @NotNull
    public static <T> PacketConstructor<T> findEmptyConstructor(@NotNull Class<T> packetClass) {
        try {
            MethodHandle constructor = LOOKUP.findConstructor(packetClass, VOID_METHOD_TYPE);
            return () -> {
                try {
                    return constructor.invoke();
                }
                catch (Throwable e) {
                    throw new IllegalStateException("couldn't create packet instance", e);
                }
            };
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return () -> {
                try {
                    return ALLOCATE_INSTANCE_HANDLE.invoke(UNSAFE, packetClass);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("couldn't allocate packet instance using Unsafe", e);
                }
            };
        }
    }

    @NotNull
    private static MethodHandle convertToGeneric(@NotNull MethodHandle handle) {
        MethodHandle target = handle.asFixedArity();
        MethodType methodType = MethodType.genericMethodType(0, true);
        target = target.asSpreader(Object[].class, handle.type().parameterCount());
        return target.asType(methodType);
    }

    static {
        MethodHandles.Lookup lookup;
        VOID_METHOD_TYPE = MethodType.methodType(Void.TYPE);
        VIRTUAL_FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class, Object.class);
        MethodHandles.Lookup normalLookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = theUnsafe.get(null);
            ALLOCATE_INSTANCE_HANDLE = normalLookup.findVirtual(UNSAFE.getClass(), "allocateInstance", MethodType.methodType(Object.class, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            MethodHandle staticFieldOffset = normalLookup.findVirtual(UNSAFE.getClass(), "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
            MethodHandle staticFieldBase = normalLookup.findVirtual(UNSAFE.getClass(), "staticFieldBase", MethodType.methodType(Object.class, Field.class));
            MethodHandle getObject = normalLookup.findVirtual(UNSAFE.getClass(), "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE));
            Field trustedLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long offset = staticFieldOffset.invoke(UNSAFE, trustedLookup);
            Object baseValue = staticFieldBase.invoke(UNSAFE, trustedLookup);
            lookup = getObject.invoke(UNSAFE, baseValue, offset);
        }
        catch (Throwable e) {
            e.printStackTrace();
            lookup = normalLookup;
        }
        LOOKUP = lookup;
    }
}

