/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.player;

import java.util.List;
import java.util.UUID;
import net.megavex.scoreboardlibrary.implementation.commons.CollectionProvider;
import net.megavex.scoreboardlibrary.implementation.player.PlayerDisplayable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayableQueue<T extends PlayerDisplayable> {
    private final UUID playerUuid;
    private final List<T> queue = CollectionProvider.list((int)1);

    public DisplayableQueue(@NotNull UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    @Nullable
    public synchronized T current() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return (T)((PlayerDisplayable)this.queue.get(0));
    }

    public synchronized void add(@NotNull T displayable) {
        Player player;
        if (this.queue.contains(displayable)) {
            throw new IllegalStateException("displayable already registered");
        }
        this.queue.add(displayable);
        if (this.current() == displayable && (player = Bukkit.getPlayer((UUID)this.playerUuid)) != null) {
            displayable.display(player);
        }
    }

    public synchronized void remove(@NotNull T displayable) {
        Player player;
        boolean wasCurrent;
        boolean bl = wasCurrent = displayable == this.current();
        if (!this.queue.remove(displayable)) {
            throw new IllegalStateException("displayable not registered");
        }
        if (!wasCurrent) {
            return;
        }
        T newDisplayable = this.current();
        if (newDisplayable != null && (player = Bukkit.getPlayer((UUID)this.playerUuid)) != null) {
            newDisplayable.display(player);
        }
    }
}

