/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.sidebar;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.translation.GlobalTranslator;
import net.megavex.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import net.megavex.scoreboardlibrary.api.objective.ObjectiveRenderType;
import net.megavex.scoreboardlibrary.api.objective.ScoreFormat;
import net.megavex.scoreboardlibrary.api.sidebar.Sidebar;
import net.megavex.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import net.megavex.scoreboardlibrary.implementation.commons.CollectionProvider;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import net.megavex.scoreboardlibrary.implementation.player.PlayerDisplayable;
import net.megavex.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import net.megavex.scoreboardlibrary.implementation.sidebar.SidebarTask;
import net.megavex.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import net.megavex.scoreboardlibrary.implementation.sidebar.line.LocaleLineHandler;
import net.megavex.scoreboardlibrary.implementation.sidebar.line.PlayerNameProvider;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class AbstractSidebar
implements Sidebar,
PlayerDisplayable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final ObjectivePacketAdapter packetAdapter;
    private final List<String> linePlayerNames;
    private final GlobalLineInfo[] lines;
    private Component title = Component.empty();
    private final Set<Player> players = CollectionProvider.set((int)8);
    private boolean closed;
    private final Queue<SidebarTask> taskQueue = new ConcurrentLinkedQueue<SidebarTask>();

    public AbstractSidebar(@NotNull ScoreboardLibraryImpl scoreboardLibrary, int maxLines) {
        this.scoreboardLibrary = scoreboardLibrary;
        String objectiveName = RandomStringUtils.randomAlphanumeric((int)16);
        this.packetAdapter = scoreboardLibrary.packetAdapter().createObjectiveAdapter(objectiveName);
        this.linePlayerNames = PlayerNameProvider.provideLinePlayerNames(maxLines);
        this.lines = new GlobalLineInfo[maxLines];
    }

    @NotNull
    protected abstract Set<Player> internalPlayers();

    protected abstract void forEachLineHandler(@NotNull Consumer<LocaleLineHandler> var1);

    @Nullable
    protected abstract LocaleLineHandler addPlayer0(@NotNull Player var1);

    @Nullable
    protected abstract LocaleLineHandler removePlayer0(@NotNull Player var1);

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.add(SidebarTask.Close.INSTANCE);
        }
    }

    public final boolean closed() {
        return this.closed;
    }

    @NotNull
    public final Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    public final boolean addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (this.players.add(player)) {
            this.taskQueue.add(new SidebarTask.AddPlayer(player));
            return true;
        }
        return false;
    }

    public final boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (this.players.remove(player)) {
            this.taskQueue.add(new SidebarTask.RemovePlayer(player));
            return true;
        }
        return false;
    }

    public final @Range(from=1L, to=15L) int maxLines() {
        return this.lines.length;
    }

    public final void line(@Range(from=0L, to=14L) int index, @Nullable ComponentLike value, @Nullable ScoreFormat scoreFormat) {
        boolean updateScore;
        this.checkClosed();
        Component component = value == null ? null : value.asComponent();
        GlobalLineInfo globalLineInfo = this.getLineInfo(index);
        boolean updateValue = !Objects.equals(globalLineInfo.value(), component);
        boolean bl = updateScore = !Objects.equals(globalLineInfo.scoreFormat(), scoreFormat);
        if (updateValue || updateScore) {
            globalLineInfo.value(component);
            globalLineInfo.scoreFormat(scoreFormat);
            this.taskQueue.add(new SidebarTask.UpdateLine(index, updateValue, updateScore));
            this.updateScores();
        }
    }

    @Nullable
    public final Component line(@Range(from=0L, to=14L) int line) {
        this.checkClosed();
        GlobalLineInfo globalLineInfo = this.lines[line];
        return globalLineInfo == null ? null : globalLineInfo.value();
    }

    @NotNull
    public final Component title() {
        return this.title;
    }

    public final void title(@NotNull ComponentLike title) {
        Preconditions.checkNotNull((Object)title);
        this.checkClosed();
        Component component = title.asComponent();
        if (!Objects.equals(this.title, component)) {
            this.title = component;
            this.taskQueue.add(SidebarTask.UpdateTitle.INSTANCE);
        }
    }

    @NotNull
    public final ScoreboardLibraryImpl scoreboardLibrary() {
        return this.scoreboardLibrary;
    }

    public final ObjectivePacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @Nullable
    public final GlobalLineInfo[] lines() {
        return this.lines;
    }

    @NotNull
    public final Queue<SidebarTask> taskQueue() {
        return this.taskQueue;
    }

    @Override
    public final void display(@NotNull Player player) {
        Set<Player> singleton = Collections.singleton(player);
        this.packetAdapter.sendProperties(singleton, PropertiesPacketType.CREATE, this.title, ObjectiveRenderType.INTEGER, (ScoreFormat)ScoreFormat.blank());
        LocaleLineHandler lineHandler = Objects.requireNonNull(this.addPlayer0(player));
        lineHandler.addPlayer(player);
        lineHandler.show(player);
        this.packetAdapter.display(singleton, (ObjectiveDisplaySlot)ObjectiveDisplaySlot.sidebar());
    }

    public final boolean tick() {
        SidebarTask task;
        while ((task = this.taskQueue.poll()) != null) {
            if (task instanceof SidebarTask.Close) {
                this.forEachLineHandler(LocaleLineHandler::hide);
                this.packetAdapter.remove(this.internalPlayers());
                for (Player player : this.internalPlayers()) {
                    Objects.requireNonNull(this.scoreboardLibrary.getPlayer(player)).sidebarQueue().remove(this);
                }
                return false;
            }
            if (task instanceof SidebarTask.AddPlayer) {
                SidebarTask.AddPlayer addPlayerTask = (SidebarTask.AddPlayer)task;
                ScoreboardLibraryPlayer slPlayer = this.scoreboardLibrary.getOrCreatePlayer(addPlayerTask.player());
                slPlayer.sidebarQueue().add(this);
                continue;
            }
            if (task instanceof SidebarTask.RemovePlayer) {
                SidebarTask.RemovePlayer removePlayerTask = (SidebarTask.RemovePlayer)task;
                LocaleLineHandler lineHandler = this.removePlayer0(removePlayerTask.player());
                if (lineHandler != null) {
                    lineHandler.hide(removePlayerTask.player());
                    lineHandler.removePlayer(removePlayerTask.player());
                    this.packetAdapter.remove(Collections.singleton(removePlayerTask.player()));
                }
                Objects.requireNonNull(this.scoreboardLibrary.getPlayer(removePlayerTask.player())).sidebarQueue().remove(this);
                continue;
            }
            if (task instanceof SidebarTask.ReloadPlayer) {
                SidebarTask.ReloadPlayer reloadPlayerTask = (SidebarTask.ReloadPlayer)task;
                LocaleLineHandler lineHandler = this.removePlayer0(reloadPlayerTask.player());
                if (lineHandler == null) continue;
                this.packetAdapter.remove(Collections.singleton(reloadPlayerTask.player()));
                lineHandler.hide(reloadPlayerTask.player());
                lineHandler.removePlayer(reloadPlayerTask.player());
                this.display(reloadPlayerTask.player());
                continue;
            }
            if (task instanceof SidebarTask.UpdateLine) {
                SidebarTask.UpdateLine updateLineTask = (SidebarTask.UpdateLine)task;
                this.forEachLineHandler(sidebar -> {
                    if (updateLineTask.updateValue()) {
                        Component value = this.lines[updateLineTask.line()].value();
                        Component renderedValue = value == null ? null : GlobalTranslator.render((Component)value, (Locale)sidebar.locale());
                        sidebar.updateLine(updateLineTask.line(), renderedValue);
                    }
                    if (updateLineTask.updateScore()) {
                        sidebar.updateScoreFormat(updateLineTask.line());
                    }
                });
                continue;
            }
            if (task instanceof SidebarTask.UpdateScores) {
                this.forEachLineHandler(LocaleLineHandler::updateScores);
                for (GlobalLineInfo line : this.lines) {
                    if (line == null) continue;
                    line.updateScore(false);
                }
                continue;
            }
            if (!(task instanceof SidebarTask.UpdateTitle)) continue;
            this.packetAdapter.sendProperties(this.internalPlayers(), PropertiesPacketType.UPDATE, this.title, ObjectiveRenderType.INTEGER, (ScoreFormat)ScoreFormat.blank());
        }
        return true;
    }

    private void updateScores() {
        int size = 0;
        for (GlobalLineInfo line : this.lines) {
            if (line == null || line.value() == null) continue;
            ++size;
        }
        boolean changed = false;
        int i = 0;
        for (GlobalLineInfo line : this.lines) {
            if (line == null || line.value() == null) continue;
            int newScore = size - i - 1;
            if (line.objectiveScore() != newScore) {
                changed = true;
                line.updateScore(true);
                line.objectiveScore(newScore);
            }
            ++i;
        }
        if (changed) {
            this.taskQueue.add(SidebarTask.UpdateScores.INSTANCE);
        }
    }

    @NotNull
    private GlobalLineInfo getLineInfo(int line) {
        GlobalLineInfo globalLineInfo = this.lines[line];
        if (globalLineInfo == null) {
            globalLineInfo = this.lines[line] = new GlobalLineInfo(this, this.linePlayerNames.get(line), line);
            this.updateScores();
        }
        return globalLineInfo;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Sidebar is closed");
        }
    }
}

