/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation;

import java.lang.reflect.InvocationTargetException;
import net.megavex.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketAdapterLoader {
    private static final String MODERN = "modern";
    private static final String V1_8_R3 = "v1_8_R3";
    private static final String PACKET_EVENTS = "packetevents";

    private PacketAdapterLoader() {
    }

    @NotNull
    public static PacketAdapterProvider loadPacketAdapter() throws NoPacketAdapterAvailableException {
        Class<?> nmsClass = PacketAdapterLoader.findAndLoadImplementationClass();
        if (nmsClass == null) {
            throw new NoPacketAdapterAvailableException();
        }
        try {
            return (PacketAdapterProvider)nmsClass.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("couldn't initialize packet adapter", e);
        }
    }

    @Nullable
    private static Class<?> findAndLoadImplementationClass() {
        Class<?> nmsClass;
        String version = Bukkit.getServer().getBukkitVersion();
        int dashIndex = version.indexOf(45);
        if (dashIndex != -1) {
            version = version.substring(0, dashIndex);
        }
        if ((nmsClass = PacketAdapterLoader.tryLoadVersion(version)) != null) {
            return nmsClass;
        }
        return PacketAdapterLoader.tryLoadPacketEvents();
    }

    @Nullable
    private static Class<?> tryLoadVersion(@NotNull String serverVersion) {
        switch (serverVersion) {
            case "1.8.8": {
                return PacketAdapterLoader.tryLoadImplementationClass(V1_8_R3);
            }
            case "1.17": 
            case "1.17.1": 
            case "1.18": 
            case "1.18.1": 
            case "1.18.2": 
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": 
            case "1.19.3": 
            case "1.19.4": 
            case "1.20": 
            case "1.20.1": 
            case "1.20.2": 
            case "1.20.3": 
            case "1.20.4": 
            case "1.20.5": 
            case "1.20.6": 
            case "1.21": {
                return PacketAdapterLoader.tryLoadImplementationClass(MODERN);
            }
        }
        String property = "net.mega".concat("vex.scoreboardlibrary.forceModern");
        if (System.getProperty(property, "").equalsIgnoreCase("true")) {
            return PacketAdapterLoader.tryLoadImplementationClass(MODERN);
        }
        return null;
    }

    @Nullable
    private static Class<?> tryLoadPacketEvents() {
        Class<?> nmsClass = PacketAdapterLoader.tryLoadImplementationClass(PACKET_EVENTS);
        if (nmsClass == null) {
            return null;
        }
        try {
            Class.forName("com.github.retrooper.packetevents.PacketEvents");
            return nmsClass;
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    @Nullable
    private static Class<?> tryLoadImplementationClass(@NotNull String name) {
        try {
            String path = "net.megavex.scoreboardlibrary.implementation.packetAdapter." + name + ".PacketAdapterProviderImpl";
            return Class.forName(path);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }
}

