/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.team;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.megavex.scoreboardlibrary.api.team.ScoreboardTeam;
import net.megavex.scoreboardlibrary.api.team.TeamDisplay;
import net.megavex.scoreboardlibrary.api.team.TeamManager;
import net.megavex.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import net.megavex.scoreboardlibrary.implementation.commons.CollectionProvider;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import net.megavex.scoreboardlibrary.implementation.player.PlayerDisplayable;
import net.megavex.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import net.megavex.scoreboardlibrary.implementation.team.ScoreboardTeamImpl;
import net.megavex.scoreboardlibrary.implementation.team.TeamDisplayImpl;
import net.megavex.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamManagerImpl
implements TeamManager,
PlayerDisplayable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final Set<Player> players = CollectionProvider.set((int)8);
    private final Map<String, ScoreboardTeamImpl> teams = new ConcurrentHashMap<String, ScoreboardTeamImpl>();
    private final Queue<TeamManagerTask> taskQueue = new ConcurrentLinkedQueue<TeamManagerTask>();
    private boolean closed;

    public TeamManagerImpl(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.add(TeamManagerTask.Close.INSTANCE);
        }
    }

    public boolean closed() {
        return this.closed;
    }

    @NotNull
    public Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @NotNull
    public Collection<ScoreboardTeam> teams() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableCollection(this.teams.values());
    }

    @Nullable
    public ScoreboardTeam team(@NotNull String name) {
        return this.teams.get(name.toLowerCase());
    }

    public boolean teamExists(@NotNull String name) {
        return this.teams.containsKey(name.toLowerCase());
    }

    @NotNull
    public ScoreboardTeam createIfAbsent(@NotNull String name, @Nullable BiFunction<Player, ScoreboardTeam, TeamDisplay> teamDisplayFunction) {
        Preconditions.checkNotNull((Object)name);
        this.checkClosed();
        name = name.toLowerCase();
        ScoreboardTeamImpl team = this.teams.get(name);
        if (team != null) {
            return team;
        }
        team = new ScoreboardTeamImpl(this, name);
        this.teams.put(name, team);
        for (Player player : this.players) {
            TeamDisplayImpl teamDisplay = teamDisplayFunction == null ? team.defaultDisplay() : teamDisplayFunction.apply(player, team);
            this.validateTeamDisplay(team, teamDisplay);
            team.displayMap().put(player, teamDisplay);
        }
        TeamManagerTask.AddTeam task = new TeamManagerTask.AddTeam(team);
        this.taskQueue.add(task);
        return team;
    }

    public boolean removeTeam(@NotNull String name) {
        Preconditions.checkNotNull((Object)name);
        this.checkClosed();
        ScoreboardTeamImpl team = this.teams.remove(name.toLowerCase());
        if (team != null) {
            this.taskQueue.add(new TeamManagerTask.RemoveTeam(team));
            return true;
        }
        return false;
    }

    public void removeTeam(@NotNull ScoreboardTeam team) {
        Preconditions.checkNotNull((Object)team);
        Preconditions.checkArgument((team.teamManager() == this ? 1 : 0) != 0);
        this.checkClosed();
        if (this.teams.remove(team.name(), (ScoreboardTeamImpl)team)) {
            this.taskQueue.add(new TeamManagerTask.RemoveTeam((ScoreboardTeamImpl)team));
        }
    }

    public boolean addPlayer(@NotNull Player player, @Nullable Function<ScoreboardTeam, TeamDisplay> teamDisplayFunction) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.add(player)) {
            return false;
        }
        for (ScoreboardTeamImpl team : this.teams.values()) {
            TeamDisplayImpl teamDisplay = teamDisplayFunction == null ? team.defaultDisplay() : teamDisplayFunction.apply(team);
            this.validateTeamDisplay(team, teamDisplay);
            team.displayMap().put(player, teamDisplay);
        }
        this.taskQueue.add(new TeamManagerTask.AddPlayer(player));
        return true;
    }

    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.remove(player)) {
            return false;
        }
        TeamManagerTask.RemovePlayer task = new TeamManagerTask.RemovePlayer(player);
        this.taskQueue.add(task);
        return true;
    }

    @NotNull
    public ScoreboardLibraryImpl scoreboardLibrary() {
        return this.scoreboardLibrary;
    }

    @NotNull
    public Queue<TeamManagerTask> taskQueue() {
        return this.taskQueue;
    }

    @Override
    public void display(@NotNull Player player) {
        for (ScoreboardTeamImpl team : this.teams.values()) {
            team.addPlayer(player);
        }
    }

    public boolean tick() {
        TeamManagerTask task;
        while ((task = this.taskQueue.poll()) != null) {
            TeamDisplayImpl teamDisplay;
            if (task instanceof TeamManagerTask.Close) {
                for (ScoreboardTeamImpl team : this.teams.values()) {
                    Set removePlayers = CollectionProvider.set((int)this.players.size());
                    for (TeamDisplayImpl value : team.displayMap().values()) {
                        removePlayers.addAll(value.players());
                    }
                    team.packetAdapter().removeTeam((Iterable)removePlayers);
                }
                for (Player player : this.players) {
                    Objects.requireNonNull(this.scoreboardLibrary.getPlayer(player)).teamManagerQueue().remove(this);
                }
                return false;
            }
            if (task instanceof TeamManagerTask.AddPlayer) {
                TeamManagerTask.AddPlayer addPlayerTask = (TeamManagerTask.AddPlayer)task;
                @NotNull Iterator<ScoreboardTeamImpl> slPlayer = this.scoreboardLibrary.getOrCreatePlayer(addPlayerTask.player());
                ((ScoreboardLibraryPlayer)((Object)slPlayer)).teamManagerQueue().add(this);
                continue;
            }
            if (task instanceof TeamManagerTask.RemovePlayer) {
                TeamManagerTask.RemovePlayer removePlayerTask = (TeamManagerTask.RemovePlayer)task;
                for (ScoreboardTeamImpl team : this.teams.values()) {
                    team.removePlayer(removePlayerTask.player());
                }
                Objects.requireNonNull(this.scoreboardLibrary.getPlayer(removePlayerTask.player())).teamManagerQueue().remove(this);
                continue;
            }
            if (task instanceof TeamManagerTask.ReloadPlayer) {
                TeamManagerTask.ReloadPlayer reloadPlayerTask = (TeamManagerTask.ReloadPlayer)task;
                for (ScoreboardTeamImpl team : this.teams.values()) {
                    TeamDisplayImpl teamDisplayImpl = team.displayMap().get(reloadPlayerTask.player());
                    if (teamDisplayImpl == null) continue;
                    teamDisplayImpl.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, Collections.singleton(reloadPlayerTask.player()));
                }
                continue;
            }
            if (task instanceof TeamManagerTask.AddTeam) {
                ScoreboardTeamImpl team;
                TeamManagerTask.AddTeam addTeamTask = (TeamManagerTask.AddTeam)task;
                team = addTeamTask.team();
                for (Player player : team.displayMap().keySet()) {
                    ScoreboardLibraryPlayer slPlayer = this.scoreboardLibrary.getPlayer(player);
                    if (slPlayer == null || slPlayer.teamManagerQueue().current() != this) continue;
                    team.addPlayer(player);
                }
                continue;
            }
            if (task instanceof TeamManagerTask.RemoveTeam) {
                TeamManagerTask.RemoveTeam removeTeamTask = (TeamManagerTask.RemoveTeam)task;
                List playersInTeam = CollectionProvider.list((int)removeTeamTask.team().displayMap().size());
                for (Map.Entry entry : removeTeamTask.team().displayMap().entrySet()) {
                    Player player = (Player)entry.getKey();
                    TeamDisplayImpl teamDisplay3 = (TeamDisplayImpl)entry.getValue();
                    if (!teamDisplay3.players().contains(player)) continue;
                    playersInTeam.add(player);
                }
                removeTeamTask.team().packetAdapter().removeTeam((Iterable)playersInTeam);
                continue;
            }
            if (task instanceof TeamManagerTask.UpdateTeamDisplay) {
                TeamManagerTask.UpdateTeamDisplay updateTeamDisplayTask = (TeamManagerTask.UpdateTeamDisplay)task;
                teamDisplay = updateTeamDisplayTask.teamDisplay();
                teamDisplay.updateTeamPackets();
                teamDisplay.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, teamDisplay.players());
                continue;
            }
            if (task instanceof TeamManagerTask.AddEntries) {
                TeamManagerTask.AddEntries addEntriesTask = (TeamManagerTask.AddEntries)task;
                teamDisplay = addEntriesTask.teamDisplay();
                teamDisplay.packetAdapter().sendEntries(EntriesPacketType.ADD, teamDisplay.players(), addEntriesTask.entries());
                continue;
            }
            if (task instanceof TeamManagerTask.RemoveEntries) {
                TeamManagerTask.RemoveEntries removeEntriesTask = (TeamManagerTask.RemoveEntries)task;
                teamDisplay = removeEntriesTask.teamDisplay();
                teamDisplay.packetAdapter().sendEntries(EntriesPacketType.REMOVE, teamDisplay.players(), removeEntriesTask.entries());
                continue;
            }
            if (!(task instanceof TeamManagerTask.ChangeTeamDisplay)) continue;
            TeamManagerTask.ChangeTeamDisplay changeTeamDisplayTask = (TeamManagerTask.ChangeTeamDisplay)task;
            changeTeamDisplayTask.team().changeTeamDisplay(changeTeamDisplayTask.player(), changeTeamDisplayTask.oldTeamDisplay(), changeTeamDisplayTask.newTeamDisplay());
        }
        return true;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("TeamManager is closed");
        }
    }

    private void validateTeamDisplay(@NotNull ScoreboardTeam team, @Nullable TeamDisplay teamDisplay) {
        if (teamDisplay == null || teamDisplay.team() != team) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        if (!(teamDisplay instanceof TeamDisplayImpl)) {
            throw new IllegalArgumentException("must be TeamDisplayImpl");
        }
    }
}

