/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.team;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.megavex.scoreboardlibrary.api.team.ScoreboardTeam;
import net.megavex.scoreboardlibrary.api.team.TeamDisplay;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import net.megavex.scoreboardlibrary.implementation.team.TeamDisplayImpl;
import net.megavex.scoreboardlibrary.implementation.team.TeamManagerImpl;
import net.megavex.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ScoreboardTeamImpl
implements ScoreboardTeam {
    private final TeamManagerImpl teamManager;
    private final String name;
    private final TeamsPacketAdapter packetAdapter;
    private final TeamDisplayImpl defaultDisplay;
    private final Map<Player, TeamDisplayImpl> displayMap = new ConcurrentHashMap<Player, TeamDisplayImpl>();

    public ScoreboardTeamImpl(@NotNull TeamManagerImpl teamManager, @NotNull String name) {
        this.teamManager = teamManager;
        this.name = name;
        this.packetAdapter = teamManager.scoreboardLibrary().packetAdapter().createTeamPacketAdapter(name);
        this.defaultDisplay = new TeamDisplayImpl(this);
    }

    @NotNull
    public TeamManagerImpl teamManager() {
        return this.teamManager;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public TeamDisplayImpl defaultDisplay() {
        return this.defaultDisplay;
    }

    @NotNull
    public TeamDisplay display(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        if (!this.teamManager.players().contains(player)) {
            throw new IllegalArgumentException("player not in TeamManager");
        }
        return Objects.requireNonNull(this.displayMap.get(player));
    }

    public void display(@NotNull Player player, @NotNull TeamDisplay teamDisplay) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)teamDisplay);
        if (!this.teamManager.players().contains(player)) {
            throw new IllegalArgumentException("player not in TeamManager");
        }
        if (teamDisplay.team() != this || !(teamDisplay instanceof TeamDisplayImpl)) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        TeamDisplayImpl oldTeamDisplay = Objects.requireNonNull(this.displayMap.put(player, (TeamDisplayImpl)teamDisplay));
        if (oldTeamDisplay == teamDisplay) {
            return;
        }
        this.teamManager.taskQueue().add(new TeamManagerTask.ChangeTeamDisplay(player, this, oldTeamDisplay, (TeamDisplayImpl)teamDisplay));
    }

    @NotNull
    public TeamDisplay createDisplay() {
        return new TeamDisplayImpl(this);
    }

    @NotNull
    public TeamsPacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Map<Player, TeamDisplayImpl> displayMap() {
        return this.displayMap;
    }

    public void addPlayer(@NotNull Player player) {
        TeamDisplayImpl teamDisplay = Objects.requireNonNull(this.displayMap.get(player));
        if (teamDisplay.players().add(player)) {
            teamDisplay.packetAdapter().sendProperties(PropertiesPacketType.CREATE, Collections.singleton(player));
        }
    }

    public void removePlayer(@NotNull Player player) {
        TeamDisplayImpl teamDisplay = Objects.requireNonNull(this.displayMap.remove(player));
        if (teamDisplay.players().remove(player)) {
            this.packetAdapter.removeTeam(Collections.singleton(player));
        }
    }

    public void changeTeamDisplay(@NotNull Player player, @NotNull TeamDisplayImpl oldTeamDisplay, @NotNull TeamDisplayImpl newTeamDisplay) {
        if (!oldTeamDisplay.players().remove(player)) {
            return;
        }
        newTeamDisplay.players().add(player);
        Set<Player> singleton = Collections.singleton(player);
        newTeamDisplay.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, singleton);
        Collection<String> oldEntries = oldTeamDisplay.entries();
        Collection<String> newEntries = newTeamDisplay.entries();
        if (oldEntries.isEmpty()) {
            newTeamDisplay.packetAdapter().sendEntries(EntriesPacketType.ADD, singleton, newEntries);
            return;
        }
        ArrayList<String> entries = new ArrayList<String>(oldEntries);
        entries.removeAll(newEntries);
        if (!entries.isEmpty()) {
            newTeamDisplay.packetAdapter().sendEntries(EntriesPacketType.REMOVE, singleton, entries);
        }
        entries = new ArrayList<String>(newEntries);
        entries.removeAll(oldEntries);
        if (!entries.isEmpty()) {
            newTeamDisplay.packetAdapter().sendEntries(EntriesPacketType.ADD, singleton, entries);
        }
    }
}

