/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.sidebar.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class PlayerNameProvider {
    private static final ChatColor[] CHAT_COLORS = ChatColor.values();
    private static final List<String> DEFAULT_NAMES = PlayerNameProvider.createLinePlayerNames(15);

    private PlayerNameProvider() {
    }

    @NotNull
    public static @Unmodifiable List<String> provideLinePlayerNames(int maxLines) {
        return maxLines <= 15 ? DEFAULT_NAMES : PlayerNameProvider.createLinePlayerNames(maxLines);
    }

    @NotNull
    private static @Unmodifiable List<String> createLinePlayerNames(int maxLines) {
        ArrayList<String> result = new ArrayList<String>(maxLines);
        int i = 0;
        while (result.size() < maxLines) {
            for (ChatColor color : CHAT_COLORS) {
                String newStr;
                String legacy = color.toString();
                String string = newStr = i == 0 ? legacy : (String)result.get(i - 1) + legacy;
                if (result.contains(newStr)) continue;
                result.add(newStr);
            }
            ++i;
        }
        return Collections.unmodifiableList(result);
    }
}

