/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.commons;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CollectionProvider {
    private static final MethodHandle mapConstructor;
    private static final MethodHandle setConstructor;
    private static final MethodHandle listConstructor;

    private CollectionProvider() {
    }

    private static MethodHandle getConstructor(MethodHandles.Lookup lookup, String fastUtilClass, Class<?> fallback, MethodType parameters) {
        Class<?> clazz;
        try {
            clazz = Class.forName(fastUtilClass);
        }
        catch (ClassNotFoundException e) {
            clazz = fallback;
        }
        try {
            return lookup.findConstructor(clazz, parameters);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @NotNull
    public static <K, V> Map<K, V> map(int capacity) {
        try {
            return (Map)mapConstructor.invokeWithArguments(capacity);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <E> Set<E> set(int capacity) {
        try {
            return (Set)setConstructor.invokeWithArguments(capacity);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <E> List<E> list(int capacity) {
        try {
            return (List)listConstructor.invokeWithArguments(capacity);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType parameters = MethodType.methodType(Void.TYPE, Integer.TYPE);
        mapConstructor = CollectionProvider.getConstructor(lookup, "it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap", HashMap.class, parameters);
        setConstructor = CollectionProvider.getConstructor(lookup, "it.unimi.dsi.fastutil.objects.ObjectOpenHashSet", HashSet.class, parameters);
        listConstructor = CollectionProvider.getConstructor(lookup, "it.unimi.dsi.fastutil.objects.ObjectArrayList", ArrayList.class, parameters);
    }
}

