/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.api.noop;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.megavex.scoreboardlibrary.api.objective.ScoreFormat;
import net.megavex.scoreboardlibrary.api.sidebar.Sidebar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

class NoopSidebar
implements Sidebar {
    private final Set<Player> players = new HashSet<Player>();
    private final int maxLines;
    private final Locale locale;
    private final Component[] lines;
    private Component title = Component.empty();
    private boolean closed;

    NoopSidebar(int maxLines, @Nullable Locale locale) {
        this.maxLines = maxLines;
        this.locale = locale;
        this.lines = new Component[maxLines];
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        return this.players.add(player);
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        return this.players.remove(player);
    }

    @Override
    public @Range(from=1L, to=15L) int maxLines() {
        return this.maxLines;
    }

    @Override
    @Nullable
    public Locale locale() {
        return this.locale;
    }

    @Override
    public void line(int index, @Nullable ComponentLike value, @Nullable ScoreFormat scoreFormat) {
        this.checkLineBounds(index);
        this.checkClosed();
        this.lines[index] = value == null ? null : value.asComponent();
    }

    @Override
    @Nullable
    public Component line(int line) {
        this.checkLineBounds(line);
        this.checkClosed();
        return this.lines[line];
    }

    @Override
    @NotNull
    public Component title() {
        return this.title;
    }

    @Override
    public void title(@NotNull ComponentLike title) {
        Preconditions.checkNotNull((Object)title);
        this.checkClosed();
        this.title = title.asComponent();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopSidebar is closed");
        }
    }

    private void checkLineBounds(int line) {
        if (line >= this.maxLines || line < 0) {
            throw new IndexOutOfBoundsException("invalid line " + line);
        }
    }
}

