/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.api.noop;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.megavex.scoreboardlibrary.api.noop.NoopTeamDisplay;
import net.megavex.scoreboardlibrary.api.noop.NoopTeamManager;
import net.megavex.scoreboardlibrary.api.team.ScoreboardTeam;
import net.megavex.scoreboardlibrary.api.team.TeamDisplay;
import net.megavex.scoreboardlibrary.api.team.TeamManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class NoopScoreboardTeam
implements ScoreboardTeam {
    private final NoopTeamManager teamManager;
    private final String name;
    private final Map<Player, TeamDisplay> displayMap = new HashMap<Player, TeamDisplay>();
    private final NoopTeamDisplay defaultDisplay = new NoopTeamDisplay(this);

    NoopScoreboardTeam(@NotNull NoopTeamManager teamManager, String name) {
        this.teamManager = teamManager;
        this.name = name;
    }

    @Override
    @NotNull
    public TeamManager teamManager() {
        return this.teamManager;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public NoopTeamDisplay defaultDisplay() {
        return this.defaultDisplay;
    }

    @Override
    @NotNull
    public TeamDisplay display(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        if (!this.teamManager.players().contains(player)) {
            throw new IllegalArgumentException("player not in TeamManager");
        }
        return Objects.requireNonNull(this.displayMap.get(player));
    }

    @Override
    public void display(@NotNull Player player, @NotNull TeamDisplay teamDisplay) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)teamDisplay);
        if (!this.teamManager.players().contains(player)) {
            throw new IllegalArgumentException("player not in TeamManager");
        }
        if (teamDisplay.team() != this || !(teamDisplay instanceof NoopTeamDisplay)) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        this.displayMap.put(player, teamDisplay);
    }

    @Override
    @NotNull
    public TeamDisplay createDisplay() {
        return new NoopTeamDisplay(this);
    }

    @NotNull
    Map<Player, TeamDisplay> displayMap() {
        return this.displayMap;
    }
}

