/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.api.noop;

import java.util.Locale;
import net.megavex.scoreboardlibrary.api.ScoreboardLibrary;
import net.megavex.scoreboardlibrary.api.noop.NoopObjectiveManager;
import net.megavex.scoreboardlibrary.api.noop.NoopSidebar;
import net.megavex.scoreboardlibrary.api.noop.NoopTeamManager;
import net.megavex.scoreboardlibrary.api.objective.ObjectiveManager;
import net.megavex.scoreboardlibrary.api.sidebar.Sidebar;
import net.megavex.scoreboardlibrary.api.team.TeamManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class NoopScoreboardLibrary
implements ScoreboardLibrary {
    private boolean closed = false;

    @Override
    @NotNull
    public Sidebar createSidebar(@Range(from=1L, to=15L) int maxLines, @Nullable Locale locale) {
        this.checkClosed();
        return new NoopSidebar(maxLines, locale);
    }

    @Override
    @NotNull
    public TeamManager createTeamManager() {
        this.checkClosed();
        return new NoopTeamManager();
    }

    @Override
    @NotNull
    public ObjectiveManager createObjectiveManager() {
        this.checkClosed();
        return new NoopObjectiveManager();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopScoreboardLibrary is closed");
        }
    }
}

