/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.deserializers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.deserializers.CucumberJsonDeserializer;

public class TagsDeserializer
extends CucumberJsonDeserializer<Tag[]> {
    @Override
    protected Tag[] deserialize(JsonNode rootNode, Configuration configuration) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (JsonNode tagNode : rootNode) {
            String tagName = tagNode.get("name").asText();
            if (!this.shouldIncludeTag(tagName, configuration.getTagsToExcludeFromChart())) continue;
            tags.add(new Tag(tagName));
        }
        return tags.toArray(new Tag[tags.size()]);
    }

    public boolean shouldIncludeTag(String tagName, Collection<Pattern> tagsToExcludeFromChart) {
        for (Pattern pattern : tagsToExcludeFromChart) {
            if (!tagName.matches(pattern.pattern())) continue;
            return false;
        }
        return true;
    }
}

