/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class TagObject
implements Reportable,
Comparable<TagObject> {
    private final String tagName;
    private final List<Element> elements = new ArrayList<Element>();
    private final String reportFileName;
    private int scenarioCounter;
    private StatusCounter elementsStatusCounter = new StatusCounter();
    private StatusCounter stepsStatusCounter = new StatusCounter();
    private long totalDuration;
    private int totalSteps;
    private Status status = Status.PASSED;

    public TagObject(String tagName) {
        if (StringUtils.isEmpty((String)tagName)) {
            throw new ValidationException("TagName cannot be null!");
        }
        this.tagName = tagName;
        this.reportFileName = Tag.generateFileName(tagName);
    }

    @Override
    public String getName() {
        return this.tagName;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public boolean addElement(Element element) {
        this.elements.add(element);
        if (this.status != Status.FAILED && element.getStatus() != Status.PASSED) {
            this.status = Status.FAILED;
        }
        if (element.isScenario()) {
            ++this.scenarioCounter;
        }
        this.elementsStatusCounter.incrementFor(element.getStatus());
        for (Step step : element.getSteps()) {
            this.stepsStatusCounter.incrementFor(step.getResult().getStatus());
            this.totalDuration += step.getDuration();
            ++this.totalSteps;
        }
        return true;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    public int getFeatures() {
        throw new NotImplementedException();
    }

    @Override
    public int getPassedFeatures() {
        throw new NotImplementedException();
    }

    @Override
    public int getFailedFeatures() {
        throw new NotImplementedException();
    }

    @Override
    public int getScenarios() {
        return this.scenarioCounter;
    }

    @Override
    public int getPassedScenarios() {
        return this.elementsStatusCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedScenarios() {
        return this.elementsStatusCounter.getValueFor(Status.FAILED);
    }

    @Override
    public long getDurations() {
        return this.totalDuration;
    }

    @Override
    public String getFormattedDurations() {
        return Util.formatDuration(this.getDurations());
    }

    @Override
    public int getSteps() {
        return this.totalSteps;
    }

    public int getNumberOfStatus(Status status) {
        return this.stepsStatusCounter.getValueFor(status);
    }

    @Override
    public int getPassedSteps() {
        return this.getNumberOfStatus(Status.PASSED);
    }

    @Override
    public int getFailedSteps() {
        return this.getNumberOfStatus(Status.FAILED);
    }

    @Override
    public int getSkippedSteps() {
        return this.getNumberOfStatus(Status.SKIPPED);
    }

    @Override
    public int getUndefinedSteps() {
        return this.getNumberOfStatus(Status.UNDEFINED);
    }

    @Override
    public int getPendingSteps() {
        return this.getNumberOfStatus(Status.PENDING);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public String getRawStatus() {
        return this.status.name().toLowerCase();
    }

    @Override
    public String getDeviceName() {
        throw new NotImplementedException();
    }

    @Override
    public int compareTo(TagObject o) {
        return Integer.signum(this.tagName.compareTo(o.getName()));
    }
}

