/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.NotImplementedException;

public class OverviewReport
implements Reportable {
    private long duration;
    private final StatusCounter featuresCounter = new StatusCounter();
    private final StatusCounter scenariosCounter = new StatusCounter();
    private final StatusCounter stepsCounter = new StatusCounter();

    public void incFeaturesFor(Status status) {
        this.featuresCounter.incrementFor(status);
    }

    @Override
    public int getFeatures() {
        return this.featuresCounter.size();
    }

    @Override
    public int getPassedFeatures() {
        return this.featuresCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedFeatures() {
        return this.featuresCounter.getValueFor(Status.FAILED);
    }

    public void incScenarioFor(Status status) {
        this.scenariosCounter.incrementFor(status);
    }

    @Override
    public int getScenarios() {
        return this.scenariosCounter.size();
    }

    @Override
    public int getPassedScenarios() {
        return this.scenariosCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedScenarios() {
        return this.scenariosCounter.getValueFor(Status.FAILED);
    }

    public void incStepsFor(Status status) {
        this.stepsCounter.incrementFor(status);
    }

    @Override
    public int getSteps() {
        return this.stepsCounter.size();
    }

    @Override
    public int getPassedSteps() {
        return this.stepsCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedSteps() {
        return this.stepsCounter.getValueFor(Status.FAILED);
    }

    @Override
    public int getSkippedSteps() {
        return this.stepsCounter.getValueFor(Status.SKIPPED);
    }

    @Override
    public int getUndefinedSteps() {
        return this.stepsCounter.getValueFor(Status.UNDEFINED);
    }

    @Override
    public int getPendingSteps() {
        return this.stepsCounter.getValueFor(Status.PENDING);
    }

    public void incDurationBy(long duration) {
        this.duration += duration;
    }

    @Override
    public long getDurations() {
        return this.duration;
    }

    @Override
    public String getFormattedDurations() {
        return Util.formatDuration(this.getDurations());
    }

    @Override
    public String getDeviceName() {
        throw new NotImplementedException();
    }

    @Override
    public String getName() {
        throw new NotImplementedException();
    }

    @Override
    public Status getStatus() {
        throw new NotImplementedException();
    }
}

