/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import org.apache.commons.io.Charsets;
import org.codehaus.plexus.util.Base64;

public class Embedded {
    private final String mime_type;
    private final String data;

    public Embedded() {
        this.mime_type = null;
        this.data = null;
    }

    public String render(int index) {
        String contentId = "embedding_" + this.hashCode();
        switch (this.mime_type) {
            case "image/png": {
                return this.buildImage("png", contentId, index);
            }
            case "image/bmp": {
                return this.buildImage("bmp", contentId, index);
            }
            case "image/jpeg": {
                return this.buildImage("jpeg", contentId, index);
            }
            case "text/plain": {
                return this.buildPlainText("plain text", contentId, index);
            }
            case "text/html": {
                return this.buildhHTML(contentId, index);
            }
        }
        return this.buildUnknown(this.mime_type, contentId, index);
    }

    private String buildImage(String imgType, String contentId, int index) {
        String encodedImageContent = "data:image/" + imgType + ";base64," + this.data;
        return Embedded.toExpandable(contentId, index, imgType, String.format("<img id=\"%s\" src=\"%s\">", contentId, encodedImageContent));
    }

    private String buildPlainText(String mimeType, String contentId, int index) {
        return Embedded.toExpandable(contentId, index, mimeType, String.format("<pre>%s</pre>", this.decodeDataFromBase()));
    }

    private String buildhHTML(String contentId, int index) {
        return Embedded.toExpandable(contentId, index, "HTML", this.decodeDataFromBase());
    }

    private String buildUnknown(String mimeType, String contentId, int index) {
        return Embedded.toExpandable(contentId, index, mimeType, "File the <a href=\"https://github.com/damianszczepanik/cucumber-reporting/issues\">bug</a> so support for this mimetype can be added.");
    }

    private static String toExpandable(String contentId, int index, String mimeType, String content) {
        return String.format("<div class=\"embedding indention\"><a onclick=\"attachment=document.getElementById('%s'); attachment.className = (attachment.className == 'hidden' ? 'visible' : 'hidden'); return false\" href=\"#\">Attachment %d (%s)</a><div id=\"%s\" class=\"hidden\">%s</div></div>", contentId, index + 1, mimeType, contentId, content);
    }

    private String decodeDataFromBase() {
        return new String(Base64.decodeBase64((byte[])this.data.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
    }
}

